/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.auto.value.AutoValue;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.extensions.events.GitReferenceUpdatedListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gerrit.server.git.AutoValue_SearchingChangeCacheImpl_CachedChange;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.InternalChangeQuery;
import com.google.gerrit.server.util.ManualRequestContext;
import com.google.gerrit.server.util.OneOffRequestContext;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import com.google.inject.util.Providers;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class SearchingChangeCacheImpl
implements GitReferenceUpdatedListener {
    private static final Logger log = LoggerFactory.getLogger(SearchingChangeCacheImpl.class);
    static final String ID_CACHE = "changes";
    private final LoadingCache<Project.NameKey, List<CachedChange>> cache;
    private final ChangeData.Factory changeDataFactory;

    @Inject
    SearchingChangeCacheImpl(@Named(value="changes") LoadingCache<Project.NameKey, List<CachedChange>> cache, ChangeData.Factory changeDataFactory) {
        this.cache = cache;
        this.changeDataFactory = changeDataFactory;
    }

    public List<ChangeData> getChangeData(ReviewDb db, Project.NameKey project) {
        try {
            List<CachedChange> cached = this.cache.get(project);
            ArrayList<ChangeData> cds = new ArrayList<ChangeData>(cached.size());
            for (CachedChange cc : cached) {
                ChangeData cd = this.changeDataFactory.create(db, cc.change());
                cd.setReviewers(cc.reviewers());
                cds.add(cd);
            }
            return Collections.unmodifiableList(cds);
        }
        catch (ExecutionException e) {
            log.warn("Cannot fetch changes for " + project, e);
            return Collections.emptyList();
        }
    }

    @Override
    public void onGitReferenceUpdated(GitReferenceUpdatedListener.Event event) {
        if (event.getRefName().startsWith("refs/changes/")) {
            this.cache.invalidate(new Project.NameKey(event.getProjectName()));
        }
    }

    static class Loader
    extends CacheLoader<Project.NameKey, List<CachedChange>> {
        private final OneOffRequestContext requestContext;
        private final Provider<InternalChangeQuery> queryProvider;

        @Inject
        Loader(OneOffRequestContext requestContext, Provider<InternalChangeQuery> queryProvider) {
            this.requestContext = requestContext;
            this.queryProvider = queryProvider;
        }

        @Override
        public List<CachedChange> load(Project.NameKey key) throws Exception {
            try (ManualRequestContext ctx = this.requestContext.open();){
                List<ChangeData> cds = ((InternalChangeQuery)this.queryProvider.get().setRequestedFields(ImmutableSet.of(ChangeField.CHANGE.getName(), ChangeField.REVIEWER.getName()))).byProject(key);
                ArrayList<AutoValue_SearchingChangeCacheImpl_CachedChange> result = new ArrayList<AutoValue_SearchingChangeCacheImpl_CachedChange>(cds.size());
                for (ChangeData cd : cds) {
                    result.add(new AutoValue_SearchingChangeCacheImpl_CachedChange(cd.change(), cd.getReviewers()));
                }
                List list = Collections.unmodifiableList(result);
                return list;
            }
        }
    }

    @AutoValue
    static abstract class CachedChange {
        CachedChange() {
        }

        abstract Change change();

        @Nullable
        abstract ReviewerSet reviewers();
    }

    public static class Module
    extends CacheModule {
        private final boolean slave;

        public Module() {
            this(false);
        }

        public Module(boolean slave) {
            this.slave = slave;
        }

        @Override
        protected void configure() {
            if (this.slave) {
                this.bind(SearchingChangeCacheImpl.class).toProvider(Providers.of(null));
            } else {
                this.cache(SearchingChangeCacheImpl.ID_CACHE, Project.NameKey.class, new TypeLiteral<List<CachedChange>>(){}).maximumWeight(0L).loader(Loader.class);
                this.bind(SearchingChangeCacheImpl.class);
                DynamicSet.bind(this.binder(), GitReferenceUpdatedListener.class).to(SearchingChangeCacheImpl.class);
            }
        }
    }
}

