/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSortedMap;
import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.index.SchemaUtil;

public abstract class SchemaDefinitions<V> {
    private final String name;
    private final ImmutableSortedMap<Integer, Schema<V>> schemas;

    protected SchemaDefinitions(String name, Class<V> valueClass) {
        this.name = Preconditions.checkNotNull(name);
        this.schemas = SchemaUtil.schemasFromClass(this.getClass(), valueClass);
    }

    public final String getName() {
        return this.name;
    }

    public final ImmutableSortedMap<Integer, Schema<V>> getSchemas() {
        return this.schemas;
    }

    public final Schema<V> get(int version) {
        Schema<V> schema = this.schemas.get(version);
        Preconditions.checkArgument(schema != null, "Unrecognized %s schema version: %s", (Object)this.name, version);
        return schema;
    }

    public final Schema<V> getLatest() {
        return this.schemas.lastEntry().getValue();
    }
}

