/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gerrit.server.index.Index;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.io.NullOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SiteIndexer<K, V, I extends Index<K, V>> {
    private static final Logger log = LoggerFactory.getLogger(SiteIndexer.class);
    protected int totalWork = -1;
    protected OutputStream progressOut = NullOutputStream.INSTANCE;
    protected PrintWriter verboseWriter = this.newPrintWriter(NullOutputStream.INSTANCE);

    public void setTotalWork(int num) {
        this.totalWork = num;
    }

    public void setProgressOut(OutputStream out) {
        this.progressOut = Preconditions.checkNotNull(out);
    }

    public void setVerboseOut(OutputStream out) {
        this.verboseWriter = this.newPrintWriter(Preconditions.checkNotNull(out));
    }

    public abstract Result indexAll(I var1);

    protected final void addErrorListener(ListenableFuture<?> future, String desc, ProgressMonitor progress, AtomicBoolean ok) {
        future.addListener(new ErrorListener(future, desc, progress, ok), MoreExecutors.directExecutor());
    }

    protected PrintWriter newPrintWriter(OutputStream out) {
        return new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
    }

    private static class ErrorListener
    implements Runnable {
        private final ListenableFuture<?> future;
        private final String desc;
        private final ProgressMonitor progress;
        private final AtomicBoolean ok;

        private ErrorListener(ListenableFuture<?> future, String desc, ProgressMonitor progress, AtomicBoolean ok) {
            this.future = future;
            this.desc = desc;
            this.progress = progress;
            this.ok = ok;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                this.future.get();
            }
            catch (InterruptedException | ExecutionException e) {
                this.fail(e);
            }
            catch (RuntimeException e) {
                this.failAndThrow(e);
            }
            catch (Error e) {
                this.failAndThrow(e);
            }
            finally {
                ProgressMonitor e = this.progress;
                synchronized (e) {
                    this.progress.update(1);
                }
            }
        }

        private void fail(Throwable t) {
            log.error("Failed to index " + this.desc, t);
            this.ok.set(false);
        }

        private void failAndThrow(RuntimeException e) {
            this.fail(e);
            throw e;
        }

        private void failAndThrow(Error e) {
            this.fail(e);
            throw e;
        }
    }

    public static class Result {
        private final long elapsedNanos;
        private final boolean success;
        private final int done;
        private final int failed;

        public Result(Stopwatch sw, boolean success, int done, int failed) {
            this.elapsedNanos = sw.elapsed(TimeUnit.NANOSECONDS);
            this.success = success;
            this.done = done;
            this.failed = failed;
        }

        public boolean success() {
            return this.success;
        }

        public int doneCount() {
            return this.done;
        }

        public int failedCount() {
            return this.failed;
        }

        public long elapsed(TimeUnit timeUnit) {
            return timeUnit.convert(this.elapsedNanos, TimeUnit.NANOSECONDS);
        }
    }
}

