/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail;

import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.mail.Encryption;
import com.google.gerrit.server.mail.receive.Protocol;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.lib.Config;

@Singleton
public class EmailSettings {
    private static final String SEND_EMAL = "sendemail";
    private static final String RECEIVE_EMAL = "receiveemail";
    public final boolean html;
    public final boolean includeDiff;
    public final int maximumDiffSize;
    public final Protocol protocol;
    public final String host;
    public final int port;
    public final String username;
    public final String password;
    public final Encryption encryption;
    public final long fetchInterval;

    @Inject
    EmailSettings(@GerritServerConfig Config cfg) {
        this.html = cfg.getBoolean(SEND_EMAL, "html", true);
        this.includeDiff = cfg.getBoolean(SEND_EMAL, "includeDiff", false);
        this.maximumDiffSize = cfg.getInt(SEND_EMAL, "maximumDiffSize", 262144);
        this.protocol = cfg.getEnum(RECEIVE_EMAL, null, "protocol", Protocol.NONE);
        this.host = cfg.getString(RECEIVE_EMAL, null, "host");
        this.port = cfg.getInt(RECEIVE_EMAL, "port", 0);
        this.username = cfg.getString(RECEIVE_EMAL, null, "username");
        this.password = cfg.getString(RECEIVE_EMAL, null, "password");
        this.encryption = cfg.getEnum(RECEIVE_EMAL, null, "encryption", Encryption.NONE);
        this.fetchInterval = cfg.getTimeUnit(RECEIVE_EMAL, null, "fetchInterval", TimeUnit.MILLISECONDS.convert(60L, TimeUnit.SECONDS), TimeUnit.MILLISECONDS);
    }
}

