/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.mail.receive;

import com.google.common.primitives.Ints;
import com.google.gerrit.server.git.WorkQueue;
import com.google.gerrit.server.mail.EmailSettings;
import com.google.gerrit.server.mail.Encryption;
import com.google.gerrit.server.mail.receive.MailMessage;
import com.google.gerrit.server.mail.receive.MailParsingException;
import com.google.gerrit.server.mail.receive.MailProcessor;
import com.google.gerrit.server.mail.receive.MailReceiver;
import com.google.gerrit.server.mail.receive.RawMailParser;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.net.pop3.POP3Client;
import org.apache.commons.net.pop3.POP3MessageInfo;
import org.apache.commons.net.pop3.POP3SClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class Pop3MailReceiver
extends MailReceiver {
    private static final Logger log = LoggerFactory.getLogger(Pop3MailReceiver.class);

    @Inject
    Pop3MailReceiver(EmailSettings mailSettings, MailProcessor mailProcessor, WorkQueue workQueue) {
        super(mailSettings, mailProcessor, workQueue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized void handleEmails(boolean async) {
        POP3Client pop3 = this.mailSettings.encryption != Encryption.NONE ? new POP3SClient(this.mailSettings.encryption.name(), true) : new POP3Client();
        if (this.mailSettings.port > 0) {
            pop3.setDefaultPort(this.mailSettings.port);
        }
        try {
            pop3.connect(this.mailSettings.host);
        }
        catch (IOException e) {
            log.error("Could not connect to POP3 email server", e);
            return;
        }
        try {
            try {
                if (!pop3.login(this.mailSettings.username, this.mailSettings.password)) {
                    log.error("Could not login to POP3 email server. Check username and password");
                    return;
                }
                try {
                    POP3MessageInfo[] messages = pop3.listMessages();
                    if (messages == null) {
                        log.error("Could not retrieve message list via POP3");
                        return;
                    }
                    log.info("Received " + messages.length + " messages via POP3");
                    ArrayList<MailMessage> mailMessages = new ArrayList<MailMessage>();
                    for (POP3MessageInfo msginfo : messages) {
                        if (msginfo == null) continue;
                        try {
                            Throwable throwable;
                            BufferedReader reader;
                            block39: {
                                block40: {
                                    reader = (BufferedReader)pop3.retrieveMessage(msginfo.number);
                                    throwable = null;
                                    if (reader != null) break block39;
                                    log.error("Could not retrieve POP3 message header for message {}", (Object)msginfo.identifier);
                                    if (reader == null) return;
                                    if (throwable == null) break block40;
                                    try {
                                        reader.close();
                                        return;
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                        return;
                                    }
                                }
                                reader.close();
                                return;
                            }
                            try {
                                int[] message = this.fetchMessage(reader);
                                MailMessage mailMessage = RawMailParser.parse(message);
                                if (this.pendingDeletion.contains(mailMessage.id())) {
                                    if (pop3.deleteMessage(msginfo.number)) {
                                        this.pendingDeletion.remove(mailMessage.id());
                                        continue;
                                    }
                                    log.error("Could not delete message " + msginfo.number);
                                    continue;
                                }
                                mailMessages.add(mailMessage);
                            }
                            catch (Throwable throwable3) {
                                throwable = throwable3;
                                throw throwable3;
                            }
                            catch (Throwable throwable4) {
                                throw throwable4;
                            }
                            finally {
                                if (reader != null) {
                                    if (throwable != null) {
                                        try {
                                            reader.close();
                                        }
                                        catch (Throwable throwable5) {
                                            throwable.addSuppressed(throwable5);
                                        }
                                    } else {
                                        reader.close();
                                    }
                                }
                            }
                        }
                        catch (MailParsingException e) {
                            log.error("Could not parse message " + msginfo.number);
                        }
                    }
                    this.dispatchMailProcessor(mailMessages, async);
                    return;
                }
                finally {
                    pop3.logout();
                }
            }
            finally {
                pop3.disconnect();
            }
        }
        catch (IOException e) {
            log.error("Error while issuing POP3 command", e);
        }
    }

    public final int[] fetchMessage(BufferedReader reader) throws IOException {
        int ch;
        ArrayList<Integer> character = new ArrayList<Integer>();
        while ((ch = reader.read()) != -1) {
            character.add(ch);
        }
        return Ints.toArray(character);
    }
}

