/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.metrics.Timer1;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.notedb.AutoValue_AbstractChangeNotes_LoadHandle;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeNotesCache;
import com.google.gerrit.server.notedb.ChangeNotesCommit;
import com.google.gerrit.server.notedb.NoteDbChangeState;
import com.google.gerrit.server.notedb.NoteDbMetrics;
import com.google.gerrit.server.notedb.NoteDbTable;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilder;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;

public abstract class AbstractChangeNotes<T> {
    protected final Args args;
    protected final NoteDbChangeState.PrimaryStorage primaryStorage;
    protected final boolean autoRebuild;
    private final Change.Id changeId;
    private ObjectId revision;
    private boolean loaded;

    AbstractChangeNotes(Args args, Change.Id changeId, @Nullable NoteDbChangeState.PrimaryStorage primaryStorage, boolean autoRebuild) {
        this.args = Preconditions.checkNotNull(args);
        this.changeId = Preconditions.checkNotNull(changeId);
        this.primaryStorage = primaryStorage;
        this.autoRebuild = primaryStorage == NoteDbChangeState.PrimaryStorage.REVIEW_DB && autoRebuild;
    }

    public Change.Id getChangeId() {
        return this.changeId;
    }

    public ObjectId getRevision() {
        return this.revision;
    }

    public T load() throws OrmException {
        boolean readOrWrite;
        if (this.loaded) {
            return this.self();
        }
        boolean read = this.args.migration.readChanges();
        if (!read && this.primaryStorage == NoteDbChangeState.PrimaryStorage.NOTE_DB) {
            throw new OrmException("NoteDb is required to read change " + this.changeId);
        }
        boolean bl = readOrWrite = read || this.args.migration.writeChanges();
        if (!readOrWrite) {
            this.loadDefaults();
            return this.self();
        }
        if (this.args.migration.failOnLoad()) {
            throw new OrmException("Reading from NoteDb is disabled");
        }
        try (Timer1.Context timer = this.args.metrics.readLatency.start(NoteDbTable.CHANGES);
             Repository repo = this.args.repoManager.openRepository(this.getProjectName());
             LoadHandle handle = this.openHandle(repo);){
            if (read) {
                this.revision = handle.id();
                this.onLoad(handle);
            } else {
                this.loadDefaults();
            }
            this.loaded = true;
        }
        catch (IOException | ConfigInvalidException e) {
            throw new OrmException(e);
        }
        return this.self();
    }

    protected ObjectId readRef(Repository repo) throws IOException {
        Ref ref = repo.getRefDatabase().exactRef(this.getRefName());
        return ref != null ? ref.getObjectId() : null;
    }

    protected LoadHandle openHandle(Repository repo) throws NoSuchChangeException, IOException {
        return this.openHandle(repo, this.readRef(repo));
    }

    protected LoadHandle openHandle(Repository repo, ObjectId id) {
        return LoadHandle.create(ChangeNotesCommit.newRevWalk(repo), id);
    }

    public T reload() throws NoSuchChangeException, OrmException {
        this.loaded = false;
        return this.load();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectId loadRevision() throws OrmException {
        if (this.loaded) {
            return this.getRevision();
        }
        if (!this.args.migration.enabled()) {
            return null;
        }
        try (Repository repo = this.args.repoManager.openRepository(this.getProjectName());){
            Ref ref = repo.getRefDatabase().exactRef(this.getRefName());
            ObjectId objectId = ref != null ? ref.getObjectId() : null;
            return objectId;
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    protected abstract void loadDefaults();

    public abstract Project.NameKey getProjectName();

    protected abstract String getRefName();

    protected abstract void onLoad(LoadHandle var1) throws NoSuchChangeException, IOException, ConfigInvalidException;

    protected final T self() {
        return (T)this;
    }

    @AutoValue
    public static abstract class LoadHandle
    implements AutoCloseable {
        public static LoadHandle create(ChangeNotesCommit.ChangeNotesRevWalk walk, ObjectId id) {
            if (ObjectId.zeroId().equals(id)) {
                id = null;
            } else if (id != null) {
                id = id.copy();
            }
            return new AutoValue_AbstractChangeNotes_LoadHandle(Preconditions.checkNotNull(walk), id);
        }

        public static LoadHandle missing() {
            return new AutoValue_AbstractChangeNotes_LoadHandle(null, null);
        }

        @Nullable
        public abstract ChangeNotesCommit.ChangeNotesRevWalk walk();

        @Nullable
        public abstract ObjectId id();

        @Override
        public void close() {
            if (this.walk() != null) {
                this.walk().close();
            }
        }
    }

    @Singleton
    @VisibleForTesting
    public static class Args {
        final GitRepositoryManager repoManager;
        final NotesMigration migration;
        final AllUsersName allUsers;
        final ChangeNoteUtil noteUtil;
        final NoteDbMetrics metrics;
        final Provider<ReviewDb> db;
        final Provider<ChangeRebuilder> rebuilder;
        final Provider<ChangeNotesCache> cache;

        @Inject
        Args(GitRepositoryManager repoManager, NotesMigration migration, AllUsersName allUsers, ChangeNoteUtil noteUtil, NoteDbMetrics metrics, Provider<ReviewDb> db, Provider<ChangeRebuilder> rebuilder, Provider<ChangeNotesCache> cache) {
            this.repoManager = repoManager;
            this.migration = migration;
            this.allUsers = allUsers;
            this.noteUtil = noteUtil;
            this.metrics = metrics;
            this.db = db;
            this.rebuilder = rebuilder;
            this.cache = cache;
        }
    }
}

