/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.google.auto.value.AutoValue;
import com.google.common.base.CharMatcher;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.TimeUtil;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.PatchLineComment;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.reviewdb.server.ReviewDbUtil;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.ReviewerSet;
import com.google.gerrit.server.notedb.AutoValue_ChangeBundle_ChangeMessageCandidate;
import com.google.gerrit.server.notedb.ChangeNoteUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.rebuild.ChangeRebuilderImpl;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.Key;
import com.google.gwtorm.server.OrmException;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class ChangeBundle {
    private static final Ordering<ChangeMessage> CHANGE_MESSAGE_ORDER = new Ordering<ChangeMessage>(){
        final Ordering<Comparable<?>> nullsFirst = Ordering.natural().nullsFirst();

        @Override
        public int compare(ChangeMessage a, ChangeMessage b) {
            return ComparisonChain.start().compare(a.getWrittenOn(), b.getWrittenOn()).compare(a.getKey().getParentKey().get(), b.getKey().getParentKey().get()).compare(this.psId(a), this.psId(b), this.nullsFirst).compare(a.getAuthor(), b.getAuthor(), ReviewDbUtil.intKeyOrdering()).compare(a.getMessage(), b.getMessage(), this.nullsFirst).result();
        }

        private Integer psId(ChangeMessage m) {
            return m.getPatchSetId() != null ? Integer.valueOf(m.getPatchSetId().get()) : null;
        }
    };
    private final Change change;
    private final ImmutableList<ChangeMessage> changeMessages;
    private final ImmutableSortedMap<PatchSet.Id, PatchSet> patchSets;
    private final ImmutableMap<PatchSetApproval.Key, PatchSetApproval> patchSetApprovals;
    private final ImmutableMap<PatchLineComment.Key, PatchLineComment> patchLineComments;
    private final ReviewerSet reviewers;
    private final Source source;

    public static ChangeBundle fromNotes(CommentsUtil commentsUtil, ChangeNotes notes) throws OrmException {
        return new ChangeBundle(notes.getChange(), notes.getChangeMessages(), notes.getPatchSets().values(), notes.getApprovals().values(), Iterables.concat(CommentsUtil.toPatchLineComments(notes.getChangeId(), PatchLineComment.Status.DRAFT, commentsUtil.draftByChange(null, notes)), CommentsUtil.toPatchLineComments(notes.getChangeId(), PatchLineComment.Status.PUBLISHED, commentsUtil.publishedByChange(null, notes))), notes.getReviewers(), Source.NOTE_DB);
    }

    private static Map<ChangeMessage.Key, ChangeMessage> changeMessageMap(Iterable<ChangeMessage> in) {
        TreeMap<ChangeMessage.Key, ChangeMessage> out = new TreeMap<ChangeMessage.Key, ChangeMessage>(new Comparator<ChangeMessage.Key>(){

            @Override
            public int compare(ChangeMessage.Key a, ChangeMessage.Key b) {
                return ComparisonChain.start().compare(a.getParentKey().get(), b.getParentKey().get()).compare((Comparable<?>)((Object)a.get()), (Comparable<?>)((Object)b.get())).result();
            }
        });
        for (ChangeMessage cm : in) {
            out.put(cm.getKey(), cm);
        }
        return out;
    }

    private static ImmutableList<ChangeMessage> changeMessageList(Iterable<ChangeMessage> in) {
        return CHANGE_MESSAGE_ORDER.immutableSortedCopy(in);
    }

    private static TreeMap<PatchSet.Id, PatchSet> patchSetMap(Iterable<PatchSet> in) {
        TreeMap<PatchSet.Id, PatchSet> out = new TreeMap<PatchSet.Id, PatchSet>(new Comparator<PatchSet.Id>(){

            @Override
            public int compare(PatchSet.Id a, PatchSet.Id b) {
                return ChangeBundle.patchSetIdChain(a, b).result();
            }
        });
        for (PatchSet ps : in) {
            out.put(ps.getId(), ps);
        }
        return out;
    }

    private static Map<PatchSetApproval.Key, PatchSetApproval> patchSetApprovalMap(Iterable<PatchSetApproval> in) {
        TreeMap<PatchSetApproval.Key, PatchSetApproval> out = new TreeMap<PatchSetApproval.Key, PatchSetApproval>(new Comparator<PatchSetApproval.Key>(){

            @Override
            public int compare(PatchSetApproval.Key a, PatchSetApproval.Key b) {
                return ChangeBundle.patchSetIdChain(a.getParentKey(), b.getParentKey()).compare(a.getAccountId().get(), b.getAccountId().get()).compare(a.getLabelId(), b.getLabelId()).result();
            }
        });
        for (PatchSetApproval psa : in) {
            out.put(psa.getKey(), psa);
        }
        return out;
    }

    private static Map<PatchLineComment.Key, PatchLineComment> patchLineCommentMap(Iterable<PatchLineComment> in) {
        TreeMap<PatchLineComment.Key, PatchLineComment> out = new TreeMap<PatchLineComment.Key, PatchLineComment>(new Comparator<PatchLineComment.Key>(){

            @Override
            public int compare(PatchLineComment.Key a, PatchLineComment.Key b) {
                Patch.Key pka = a.getParentKey();
                Patch.Key pkb = b.getParentKey();
                return ChangeBundle.patchSetIdChain(pka.getParentKey(), pkb.getParentKey()).compare((Comparable<?>)((Object)pka.get()), (Comparable<?>)((Object)pkb.get())).compare((Comparable<?>)((Object)a.get()), (Comparable<?>)((Object)b.get())).result();
            }
        });
        for (PatchLineComment plc : in) {
            out.put(plc.getKey(), plc);
        }
        return out;
    }

    private static ComparisonChain patchSetIdChain(PatchSet.Id a, PatchSet.Id b) {
        return ComparisonChain.start().compare(a.getParentKey().get(), b.getParentKey().get()).compare(a.get(), b.get());
    }

    private static void checkColumns(Class<?> clazz, Integer ... expected) {
        TreeSet<Integer> ids = new TreeSet<Integer>();
        for (Field f : clazz.getDeclaredFields()) {
            Column col = f.getAnnotation(Column.class);
            if (col == null) continue;
            ids.add(col.id());
        }
        TreeSet<Integer> expectedIds = Sets.newTreeSet(Arrays.asList(expected));
        Preconditions.checkState(ids.equals(expectedIds), "Unexpected column set for %s: %s != %s", (Object)clazz.getSimpleName(), ids, expectedIds);
    }

    public ChangeBundle(Change change, Iterable<ChangeMessage> changeMessages, Iterable<PatchSet> patchSets, Iterable<PatchSetApproval> patchSetApprovals, Iterable<PatchLineComment> patchLineComments, ReviewerSet reviewers, Source source) {
        this.change = Preconditions.checkNotNull(change);
        this.changeMessages = ChangeBundle.changeMessageList(changeMessages);
        this.patchSets = ImmutableSortedMap.copyOfSorted(ChangeBundle.patchSetMap(patchSets));
        this.patchSetApprovals = ImmutableMap.copyOf(ChangeBundle.patchSetApprovalMap(patchSetApprovals));
        this.patchLineComments = ImmutableMap.copyOf(ChangeBundle.patchLineCommentMap(patchLineComments));
        this.reviewers = Preconditions.checkNotNull(reviewers);
        this.source = Preconditions.checkNotNull(source);
        for (ChangeMessage m : this.changeMessages) {
            Preconditions.checkArgument(m.getKey().getParentKey().equals(change.getId()));
        }
        for (PatchSet.Id id : this.patchSets.keySet()) {
            Preconditions.checkArgument(id.getParentKey().equals(change.getId()));
        }
        for (Key<PatchSet.Id> k : this.patchSetApprovals.keySet()) {
            Preconditions.checkArgument(((PatchSetApproval.Key)k).getParentKey().getParentKey().equals(change.getId()));
        }
        for (Key<PatchSet.Id> k : this.patchLineComments.keySet()) {
            Preconditions.checkArgument(((PatchLineComment.Key)k).getParentKey().getParentKey().getParentKey().equals(change.getId()));
        }
    }

    public Change getChange() {
        return this.change;
    }

    public ImmutableCollection<ChangeMessage> getChangeMessages() {
        return this.changeMessages;
    }

    public ImmutableCollection<PatchSet> getPatchSets() {
        return this.patchSets.values();
    }

    public ImmutableCollection<PatchSetApproval> getPatchSetApprovals() {
        return this.patchSetApprovals.values();
    }

    public ImmutableCollection<PatchLineComment> getPatchLineComments() {
        return this.patchLineComments.values();
    }

    public ReviewerSet getReviewers() {
        return this.reviewers;
    }

    public Source getSource() {
        return this.source;
    }

    public ImmutableList<String> differencesFrom(ChangeBundle o) {
        ArrayList<String> diffs = new ArrayList<String>();
        ChangeBundle.diffChanges(diffs, this, o);
        ChangeBundle.diffChangeMessages(diffs, this, o);
        ChangeBundle.diffPatchSets(diffs, this, o);
        ChangeBundle.diffPatchSetApprovals(diffs, this, o);
        ChangeBundle.diffReviewers(diffs, this, o);
        ChangeBundle.diffPatchLineComments(diffs, this, o);
        return ImmutableList.copyOf(diffs);
    }

    private Timestamp getFirstPatchSetTime() {
        if (this.patchSets.isEmpty()) {
            return this.change.getCreatedOn();
        }
        return this.patchSets.firstEntry().getValue().getCreatedOn();
    }

    private Timestamp getLatestTimestamp() {
        Ordering o = Ordering.natural().nullsFirst();
        Timestamp ts = null;
        for (ChangeMessage cm : this.filterChangeMessages()) {
            ts = o.max(ts, cm.getWrittenOn());
        }
        for (PatchSet ps : this.getPatchSets()) {
            ts = o.max(ts, ps.getCreatedOn());
        }
        for (PatchSetApproval psa : this.filterPatchSetApprovals().values()) {
            ts = o.max(ts, psa.getGranted());
        }
        for (PatchLineComment plc : this.filterPatchLineComments().values()) {
            if (plc.getStatus() == PatchLineComment.Status.DRAFT) continue;
            ts = o.max(ts, plc.getWrittenOn());
        }
        return MoreObjects.firstNonNull(ts, this.change.getLastUpdatedOn());
    }

    private Map<PatchSetApproval.Key, PatchSetApproval> filterPatchSetApprovals() {
        return this.limitToValidPatchSets(this.patchSetApprovals, PatchSetApproval.Key::getParentKey);
    }

    private Map<PatchLineComment.Key, PatchLineComment> filterPatchLineComments() {
        return this.limitToValidPatchSets(this.patchLineComments, k -> k.getParentKey().getParentKey());
    }

    private <K, V> Map<K, V> limitToValidPatchSets(Map<K, V> in, Function<K, PatchSet.Id> func) {
        return Maps.filterKeys(in, Predicates.compose(this.validPatchSetPredicate(), func));
    }

    private Predicate<PatchSet.Id> validPatchSetPredicate() {
        return this.patchSets::containsKey;
    }

    private Collection<ChangeMessage> filterChangeMessages() {
        Predicate<PatchSet.Id> validPatchSet = this.validPatchSetPredicate();
        return Collections2.filter(this.changeMessages, m -> {
            PatchSet.Id psId = m.getPatchSetId();
            if (psId == null) {
                return true;
            }
            return validPatchSet.apply(psId);
        });
    }

    private static void diffChanges(List<String> diffs, ChangeBundle bundleA, ChangeBundle bundleB) {
        Change a = bundleA.change;
        Change b = bundleB.change;
        String desc = a.getId().equals(b.getId()) ? ChangeBundle.describe(a.getId()) : "Changes";
        boolean excludeCreatedOn = false;
        boolean excludeCurrentPatchSetId = false;
        boolean excludeTopic = false;
        Timestamp aUpdated = a.getLastUpdatedOn();
        Timestamp bUpdated = b.getLastUpdatedOn();
        boolean excludeSubject = false;
        boolean excludeOrigSubj = false;
        String aSubj = Strings.nullToEmpty(a.getSubject());
        String bSubj = Strings.nullToEmpty(b.getSubject());
        if (bundleA.source == Source.REVIEW_DB && bundleB.source == Source.NOTE_DB) {
            excludeCreatedOn = !ChangeBundle.timestampsDiffer(bundleA, bundleA.getFirstPatchSetTime(), bundleB, b.getCreatedOn());
            aSubj = ChangeBundle.cleanReviewDbSubject(aSubj);
            bSubj = ChangeBundle.cleanNoteDbSubject(bSubj);
            excludeCurrentPatchSetId = !bundleA.validPatchSetPredicate().apply(a.currentPatchSetId());
            excludeSubject = bSubj.startsWith(aSubj) || excludeCurrentPatchSetId;
            excludeOrigSubj = true;
            String aTopic = ChangeBundle.trimOrNull(a.getTopic());
            excludeTopic = Objects.equals(aTopic, b.getTopic()) || "".equals(aTopic) && b.getTopic() == null;
            aUpdated = bundleA.getLatestTimestamp();
        } else if (bundleA.source == Source.NOTE_DB && bundleB.source == Source.REVIEW_DB) {
            excludeCreatedOn = !ChangeBundle.timestampsDiffer(bundleA, a.getCreatedOn(), bundleB, bundleB.getFirstPatchSetTime());
            aSubj = ChangeBundle.cleanNoteDbSubject(aSubj);
            bSubj = ChangeBundle.cleanReviewDbSubject(bSubj);
            excludeCurrentPatchSetId = !bundleB.validPatchSetPredicate().apply(b.currentPatchSetId());
            excludeSubject = aSubj.startsWith(bSubj) || excludeCurrentPatchSetId;
            excludeOrigSubj = true;
            String bTopic = ChangeBundle.trimOrNull(b.getTopic());
            excludeTopic = Objects.equals(bTopic, a.getTopic()) || a.getTopic() == null && "".equals(bTopic);
            bUpdated = bundleB.getLatestTimestamp();
        }
        String subjectField = "subject";
        String updatedField = "lastUpdatedOn";
        ArrayList<String> exclude = Lists.newArrayList(subjectField, updatedField, "noteDbState", "rowVersion");
        if (excludeCreatedOn) {
            exclude.add("createdOn");
        }
        if (excludeCurrentPatchSetId) {
            exclude.add("currentPatchSetId");
        }
        if (excludeOrigSubj) {
            exclude.add("originalSubject");
        }
        if (excludeTopic) {
            exclude.add("topic");
        }
        ChangeBundle.diffColumnsExcluding(diffs, Change.class, desc, bundleA, a, bundleB, b, exclude);
        if (ChangeBundle.timestampsDiffer(bundleA, a.getLastUpdatedOn(), bundleB, b.getLastUpdatedOn())) {
            ChangeBundle.diffTimestamps(diffs, desc, bundleA, aUpdated, bundleB, bUpdated, "effective last updated time");
        }
        if (!excludeSubject) {
            ChangeBundle.diffValues(diffs, desc, aSubj, bSubj, subjectField);
        }
    }

    private static String trimOrNull(String s) {
        return s != null ? CharMatcher.whitespace().trimFrom(s) : null;
    }

    private static String cleanReviewDbSubject(String s) {
        s = CharMatcher.is(' ').trimLeadingFrom(s);
        int rn = s.indexOf("\r \r ");
        if (rn >= 0) {
            s = s.substring(0, rn);
        }
        return ChangeNoteUtil.sanitizeFooter(s);
    }

    private static String cleanNoteDbSubject(String s) {
        return ChangeNoteUtil.sanitizeFooter(s);
    }

    private static void diffChangeMessages(List<String> diffs, ChangeBundle bundleA, ChangeBundle bundleB) {
        if (bundleA.source == Source.REVIEW_DB && bundleB.source == Source.REVIEW_DB) {
            Map<ChangeMessage.Key, ChangeMessage> as = ChangeBundle.changeMessageMap(bundleA.filterChangeMessages());
            Map<ChangeMessage.Key, ChangeMessage> bs = ChangeBundle.changeMessageMap(bundleB.filterChangeMessages());
            for (ChangeMessage.Key k : ChangeBundle.diffKeySets(diffs, as, bs)) {
                ChangeMessage a = as.get(k);
                ChangeMessage b = bs.get(k);
                String desc = ChangeBundle.describe(k);
                ChangeBundle.diffColumns(diffs, ChangeMessage.class, desc, bundleA, a, bundleB, b);
            }
            return;
        }
        Change.Id id = bundleA.getChange().getId();
        Preconditions.checkArgument(id.equals(bundleB.getChange().getId()));
        LinkedList<ChangeMessage> as = new LinkedList<ChangeMessage>(bundleA.filterChangeMessages());
        LinkedListMultimap<ChangeMessageCandidate, ChangeMessage> bs = LinkedListMultimap.create();
        for (ChangeMessage b : bundleB.filterChangeMessages()) {
            bs.put(ChangeMessageCandidate.create(b), b);
        }
        Iterator ait = as.iterator();
        block2: while (ait.hasNext()) {
            ChangeMessage a = (ChangeMessage)ait.next();
            Iterator bit = bs.get((Object)ChangeMessageCandidate.create(a)).iterator();
            while (bit.hasNext()) {
                ChangeMessage b = (ChangeMessage)bit.next();
                if (!ChangeBundle.changeMessagesMatch(bundleA, a, bundleB, b)) continue;
                ait.remove();
                bit.remove();
                continue block2;
            }
        }
        if (as.isEmpty() && bs.isEmpty()) {
            return;
        }
        StringBuilder sb = new StringBuilder("ChangeMessages differ for Change.Id ").append(id).append('\n');
        if (!as.isEmpty()) {
            sb.append("Only in A:");
            for (ChangeMessage cm : as) {
                sb.append("\n  ").append(cm);
            }
            if (!bs.isEmpty()) {
                sb.append('\n');
            }
        }
        if (!bs.isEmpty()) {
            sb.append("Only in B:");
            for (ChangeMessage cm : CHANGE_MESSAGE_ORDER.sortedCopy(bs.values())) {
                sb.append("\n  ").append(cm);
            }
        }
        diffs.add(sb.toString());
    }

    private static boolean changeMessagesMatch(ChangeBundle bundleA, ChangeMessage a, ChangeBundle bundleB, ChangeMessage b) {
        ArrayList<String> tempDiffs = new ArrayList<String>();
        String temp = "temp";
        Timestamp ta = a.getWrittenOn();
        Timestamp tb = b.getWrittenOn();
        PatchSet psa = bundleA.patchSets.get(a.getPatchSetId());
        PatchSet psb = bundleB.patchSets.get(b.getPatchSetId());
        boolean excludePatchSet = false;
        boolean excludeWrittenOn = false;
        if (bundleA.source == Source.REVIEW_DB && bundleB.source == Source.NOTE_DB) {
            excludePatchSet = a.getPatchSetId() == null;
            excludeWrittenOn = psa != null && psb != null && ta.before(psa.getCreatedOn()) && tb.equals(psb.getCreatedOn());
        } else if (bundleA.source == Source.NOTE_DB && bundleB.source == Source.REVIEW_DB) {
            excludePatchSet = b.getPatchSetId() == null;
            excludeWrittenOn = psa != null && psb != null && tb.before(psb.getCreatedOn()) && ta.equals(psa.getCreatedOn());
        }
        ArrayList<String> exclude = Lists.newArrayList("key");
        if (excludePatchSet) {
            exclude.add("patchset");
        }
        if (excludeWrittenOn) {
            exclude.add("writtenOn");
        }
        ChangeBundle.diffColumnsExcluding(tempDiffs, ChangeMessage.class, temp, bundleA, a, bundleB, b, exclude);
        return tempDiffs.isEmpty();
    }

    private static void diffPatchSets(List<String> diffs, ChangeBundle bundleA, ChangeBundle bundleB) {
        ImmutableSortedMap<PatchSet.Id, PatchSet> as = bundleA.patchSets;
        ImmutableSortedMap<PatchSet.Id, PatchSet> bs = bundleB.patchSets;
        Set<PatchSet.Id> ids = ChangeBundle.diffKeySets(diffs, as, bs);
        boolean excludeCreatedOn = false;
        if (bundleA.source == Source.REVIEW_DB && bundleB.source == Source.NOTE_DB) {
            excludeCreatedOn = !ChangeBundle.createdOnIsMonotonic(as, ids) && ChangeBundle.createdOnIsMonotonic(bs, ids);
        } else if (bundleA.source == Source.NOTE_DB && bundleB.source == Source.REVIEW_DB) {
            excludeCreatedOn = ChangeBundle.createdOnIsMonotonic(as, ids) && !ChangeBundle.createdOnIsMonotonic(bs, ids);
        }
        for (PatchSet.Id id : ids) {
            PatchSet a = (PatchSet)as.get(id);
            PatchSet b = (PatchSet)bs.get(id);
            String desc = ChangeBundle.describe(id);
            String pushCertField = "pushCertificate";
            boolean excludeDesc = false;
            if (bundleA.source == Source.REVIEW_DB && bundleB.source == Source.NOTE_DB) {
                excludeDesc = Objects.equals(ChangeBundle.trimOrNull(a.getDescription()), b.getDescription());
            } else if (bundleA.source == Source.NOTE_DB && bundleB.source == Source.REVIEW_DB) {
                excludeDesc = Objects.equals(a.getDescription(), ChangeBundle.trimOrNull(b.getDescription()));
            }
            ArrayList<String> exclude = Lists.newArrayList(pushCertField);
            if (excludeCreatedOn) {
                exclude.add("createdOn");
            }
            if (excludeDesc) {
                exclude.add("description");
            }
            ChangeBundle.diffColumnsExcluding(diffs, PatchSet.class, desc, bundleA, a, bundleB, b, exclude);
            ChangeBundle.diffValues(diffs, desc, ChangeBundle.trimPushCert(a), ChangeBundle.trimPushCert(b), pushCertField);
        }
    }

    private static String trimPushCert(PatchSet ps) {
        if (ps.getPushCertificate() == null) {
            return null;
        }
        return CharMatcher.is('\n').trimTrailingFrom(ps.getPushCertificate());
    }

    private static boolean createdOnIsMonotonic(Map<?, PatchSet> patchSets, Set<PatchSet.Id> limitToIds) {
        List orderedById = patchSets.values().stream().filter(ps -> limitToIds.contains(ps.getId())).sorted(ChangeUtil.PS_ID_ORDER).collect(Collectors.toList());
        return Ordering.natural().onResultOf(PatchSet::getCreatedOn).isOrdered(orderedById);
    }

    private static void diffPatchSetApprovals(List<String> diffs, ChangeBundle bundleA, ChangeBundle bundleB) {
        Map<PatchSetApproval.Key, PatchSetApproval> as = bundleA.filterPatchSetApprovals();
        Map<PatchSetApproval.Key, PatchSetApproval> bs = bundleB.filterPatchSetApprovals();
        for (PatchSetApproval.Key k : ChangeBundle.diffKeySets(diffs, as, bs)) {
            boolean excludeTag;
            PatchSetApproval a = as.get(k);
            PatchSetApproval b = bs.get(k);
            String desc = ChangeBundle.describe(k);
            Timestamp ta = a.getGranted();
            Timestamp tb = b.getGranted();
            PatchSet psa = Preconditions.checkNotNull(bundleA.patchSets.get(a.getPatchSetId()));
            PatchSet psb = Preconditions.checkNotNull(bundleB.patchSets.get(b.getPatchSetId()));
            boolean excludeGranted = false;
            boolean excludePostSubmit = false;
            ArrayList<String> exclude = new ArrayList<String>(1);
            if (bundleA.source == Source.REVIEW_DB && bundleB.source == Source.NOTE_DB) {
                excludeGranted = ta.before(psa.getCreatedOn()) && tb.equals(psb.getCreatedOn()) || ta.compareTo(tb) < 0;
                excludePostSubmit = a.getValue() == 0 && b.isPostSubmit();
            } else if (bundleA.source == Source.NOTE_DB && bundleB.source == Source.REVIEW_DB) {
                excludeGranted = tb.before(psb.getCreatedOn()) && ta.equals(psa.getCreatedOn()) || tb.compareTo(ta) < 0;
                excludePostSubmit = b.getValue() == 0 && a.isPostSubmit();
            }
            boolean bl = excludeTag = bundleA.source != bundleB.source && a.isLegacySubmit() && b.isLegacySubmit();
            if (excludeGranted) {
                exclude.add("granted");
            }
            if (excludePostSubmit) {
                exclude.add("postSubmit");
            }
            if (excludeTag) {
                exclude.add("tag");
            }
            ChangeBundle.diffColumnsExcluding(diffs, PatchSetApproval.class, desc, bundleA, a, bundleB, b, exclude);
        }
    }

    private static void diffReviewers(List<String> diffs, ChangeBundle bundleA, ChangeBundle bundleB) {
        ChangeBundle.diffSets(diffs, bundleA.reviewers.all(), bundleB.reviewers.all(), "reviewer");
    }

    private static void diffPatchLineComments(List<String> diffs, ChangeBundle bundleA, ChangeBundle bundleB) {
        Map<PatchLineComment.Key, PatchLineComment> as = bundleA.filterPatchLineComments();
        Map<PatchLineComment.Key, PatchLineComment> bs = bundleB.filterPatchLineComments();
        for (PatchLineComment.Key k : ChangeBundle.diffKeySets(diffs, as, bs)) {
            PatchLineComment a = as.get(k);
            PatchLineComment b = bs.get(k);
            String desc = ChangeBundle.describe(k);
            ChangeBundle.diffColumns(diffs, PatchLineComment.class, desc, bundleA, a, bundleB, b);
        }
    }

    private static <T> Set<T> diffKeySets(List<String> diffs, Map<T, ?> a, Map<T, ?> b) {
        if (a.isEmpty() && b.isEmpty()) {
            return a.keySet();
        }
        String clazz = ChangeBundle.keyClass((!a.isEmpty() ? a.keySet() : b.keySet()).iterator().next());
        return ChangeBundle.diffSets(diffs, a.keySet(), b.keySet(), clazz);
    }

    private static <T> Set<T> diffSets(List<String> diffs, Set<T> as, Set<T> bs, String desc) {
        if (as.isEmpty() && bs.isEmpty()) {
            return as;
        }
        Sets.SetView<T> aNotB = Sets.difference(as, bs);
        Sets.SetView<T> bNotA = Sets.difference(bs, as);
        if (aNotB.isEmpty() && bNotA.isEmpty()) {
            return as;
        }
        diffs.add(desc + " sets differ: " + aNotB + " only in A; " + bNotA + " only in B");
        return Sets.intersection(as, bs);
    }

    private static <T> void diffColumns(List<String> diffs, Class<T> clazz, String desc, ChangeBundle bundleA, T a, ChangeBundle bundleB, T b) {
        ChangeBundle.diffColumnsExcluding(diffs, clazz, desc, bundleA, a, bundleB, b, new String[0]);
    }

    private static <T> void diffColumnsExcluding(List<String> diffs, Class<T> clazz, String desc, ChangeBundle bundleA, T a, ChangeBundle bundleB, T b, String ... exclude) {
        ChangeBundle.diffColumnsExcluding(diffs, clazz, desc, bundleA, a, bundleB, b, Arrays.asList(exclude));
    }

    private static <T> void diffColumnsExcluding(List<String> diffs, Class<T> clazz, String desc, ChangeBundle bundleA, T a, ChangeBundle bundleB, T b, Iterable<String> exclude) {
        LinkedHashSet<String> toExclude = Sets.newLinkedHashSet(exclude);
        for (Field f : clazz.getDeclaredFields()) {
            Column col = f.getAnnotation(Column.class);
            if (col == null || toExclude.remove(f.getName())) continue;
            f.setAccessible(true);
            try {
                if (Timestamp.class.isAssignableFrom(f.getType())) {
                    ChangeBundle.diffTimestamps(diffs, desc, bundleA, a, bundleB, b, f.getName());
                    continue;
                }
                ChangeBundle.diffValues(diffs, desc, f.get(a), f.get(b), f.getName());
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Preconditions.checkArgument(toExclude.isEmpty(), "requested columns to exclude not present in %s: %s", (Object)clazz.getSimpleName(), toExclude);
    }

    private static void diffTimestamps(List<String> diffs, String desc, ChangeBundle bundleA, Object a, ChangeBundle bundleB, Object b, String field) {
        Timestamp tb;
        Timestamp ta;
        Preconditions.checkArgument(a.getClass() == b.getClass());
        Class<?> clazz = a.getClass();
        try {
            Field f = clazz.getDeclaredField(field);
            Preconditions.checkArgument(f.getAnnotation(Column.class) != null);
            f.setAccessible(true);
            ta = (Timestamp)f.get(a);
            tb = (Timestamp)f.get(b);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new IllegalArgumentException(e);
        }
        ChangeBundle.diffTimestamps(diffs, desc, bundleA, ta, bundleB, tb, field);
    }

    private static void diffTimestamps(List<String> diffs, String desc, ChangeBundle bundleA, Timestamp ta, ChangeBundle bundleB, Timestamp tb, String fieldDesc) {
        if (bundleA.source == bundleB.source || ta == null || tb == null) {
            ChangeBundle.diffValues(diffs, desc, ta, tb, fieldDesc);
        } else if (bundleA.source == Source.NOTE_DB) {
            ChangeBundle.diffTimestamps(diffs, desc, bundleA.getChange(), ta, bundleB.getChange(), tb, fieldDesc);
        } else {
            ChangeBundle.diffTimestamps(diffs, desc, bundleB.getChange(), tb, bundleA.getChange(), ta, fieldDesc);
        }
    }

    private static boolean timestampsDiffer(ChangeBundle bundleA, Timestamp ta, ChangeBundle bundleB, Timestamp tb) {
        ArrayList<String> tempDiffs = new ArrayList<String>(1);
        ChangeBundle.diffTimestamps(tempDiffs, "temp", bundleA, ta, bundleB, tb, "temp");
        return !tempDiffs.isEmpty();
    }

    private static void diffTimestamps(List<String> diffs, String desc, Change changeFromNoteDb, Timestamp tsFromNoteDb, Change changeFromReviewDb, Timestamp tsFromReviewDb, String field) {
        Preconditions.checkArgument(tsFromNoteDb.equals(TimeUtil.roundToSecond(tsFromNoteDb)), "%s from NoteDb has non-rounded %s timestamp: %s", (Object)desc, (Object)field, (Object)tsFromNoteDb);
        if (tsFromReviewDb.before(changeFromReviewDb.getCreatedOn()) && tsFromNoteDb.equals(changeFromNoteDb.getCreatedOn())) {
            return;
        }
        long delta = tsFromReviewDb.getTime() - tsFromNoteDb.getTime();
        long max = ChangeRebuilderImpl.MAX_WINDOW_MS;
        if (delta < 0L || delta > max) {
            diffs.add(field + " differs for " + desc + " in NoteDb vs. ReviewDb: {" + tsFromNoteDb + "} != {" + tsFromReviewDb + "}");
        }
    }

    private static void diffValues(List<String> diffs, String desc, Object va, Object vb, String name) {
        if (!Objects.equals(va, vb)) {
            diffs.add(name + " differs for " + desc + ": {" + va + "} != {" + vb + "}");
        }
    }

    private static String describe(Object key) {
        return ChangeBundle.keyClass(key) + " " + key;
    }

    private static String keyClass(Object obj) {
        Class<?> clazz = obj.getClass();
        String name = clazz.getSimpleName();
        Preconditions.checkArgument(name.endsWith("Key") || name.endsWith("Id"), "not an Id/Key class: %s", (Object)name);
        if (name.equals("Key") || name.equals("Id")) {
            return clazz.getEnclosingClass().getSimpleName() + "." + name;
        }
        if (name.startsWith("AutoValue_")) {
            return name.substring(name.lastIndexOf(95) + 1);
        }
        return name;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{id=" + this.change.getId() + ", ChangeMessage[" + this.changeMessages.size() + "], PatchSet[" + this.patchSets.size() + "], PatchSetApproval[" + this.patchSetApprovals.size() + "], PatchLineComment[" + this.patchLineComments.size() + "]}";
    }

    static {
        ChangeBundle.checkColumns(Change.Id.class, 1);
        ChangeBundle.checkColumns(Change.class, 1, 2, 3, 4, 5, 7, 8, 10, 12, 13, 14, 17, 18, 19, 101);
        ChangeBundle.checkColumns(ChangeMessage.Key.class, 1, 2);
        ChangeBundle.checkColumns(ChangeMessage.class, 1, 2, 3, 4, 5, 6, 7);
        ChangeBundle.checkColumns(PatchSet.Id.class, 1, 2);
        ChangeBundle.checkColumns(PatchSet.class, 1, 2, 3, 4, 5, 6, 8, 9);
        ChangeBundle.checkColumns(PatchSetApproval.Key.class, 1, 2, 3);
        ChangeBundle.checkColumns(PatchSetApproval.class, 1, 2, 3, 6, 7, 8);
        ChangeBundle.checkColumns(PatchLineComment.Key.class, 1, 2);
        ChangeBundle.checkColumns(PatchLineComment.class, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);
    }

    @AutoValue
    static abstract class ChangeMessageCandidate {
        ChangeMessageCandidate() {
        }

        static ChangeMessageCandidate create(ChangeMessage cm) {
            return new AutoValue_ChangeBundle_ChangeMessageCandidate(cm.getAuthor(), cm.getMessage(), cm.getTag());
        }

        @Nullable
        abstract Account.Id author();

        @Nullable
        abstract String message();

        @Nullable
        abstract String tag();
    }

    public static enum Source {
        REVIEW_DB,
        NOTE_DB;

    }
}

