/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb;

import com.github.rholder.retry.RetryException;
import com.github.rholder.retry.Retryer;
import com.github.rholder.retry.RetryerBuilder;
import com.github.rholder.retry.StopStrategies;
import com.github.rholder.retry.WaitStrategies;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import com.google.common.util.concurrent.Runnables;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gwtorm.server.OrmException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.RefUpdate;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.transport.ReceiveCommand;

public class RepoSequence {
    private static final Retryer<RefUpdate.Result> RETRYER = RepoSequence.retryerBuilder().build();
    private final GitRepositoryManager repoManager;
    private final Project.NameKey projectName;
    private final String refName;
    private final Seed seed;
    private final int batchSize;
    private final Runnable afterReadRef;
    private final Retryer<RefUpdate.Result> retryer;
    private final Lock counterLock;
    private int limit;
    private int counter;
    @VisibleForTesting
    int acquireCount;

    @VisibleForTesting
    static RetryerBuilder<RefUpdate.Result> retryerBuilder() {
        return RetryerBuilder.newBuilder().retryIfResult(Predicates.equalTo(RefUpdate.Result.LOCK_FAILURE)).withWaitStrategy(WaitStrategies.join(WaitStrategies.exponentialWait(5L, TimeUnit.SECONDS), WaitStrategies.randomWait(50L, TimeUnit.MILLISECONDS))).withStopStrategy(StopStrategies.stopAfterDelay(30L, TimeUnit.SECONDS));
    }

    public RepoSequence(GitRepositoryManager repoManager, Project.NameKey projectName, String name, Seed seed, int batchSize) {
        this(repoManager, projectName, name, seed, batchSize, Runnables.doNothing(), RETRYER);
    }

    @VisibleForTesting
    RepoSequence(GitRepositoryManager repoManager, Project.NameKey projectName, String name, Seed seed, int batchSize, Runnable afterReadRef, Retryer<RefUpdate.Result> retryer) {
        this.repoManager = Preconditions.checkNotNull(repoManager, "repoManager");
        this.projectName = Preconditions.checkNotNull(projectName, "projectName");
        Preconditions.checkArgument(name != null && !name.startsWith("refs/") && !name.startsWith("refs/sequences/".substring("refs/".length())), "name should be a suffix to follow \"refs/sequences/\", got: %s", (Object)name);
        this.refName = "refs/sequences/" + name;
        this.seed = Preconditions.checkNotNull(seed, "seed");
        Preconditions.checkArgument(batchSize > 0, "expected batchSize > 0, got: %s", batchSize);
        this.batchSize = batchSize;
        this.afterReadRef = Preconditions.checkNotNull(afterReadRef, "afterReadRef");
        this.retryer = Preconditions.checkNotNull(retryer, "retryer");
        this.counterLock = new ReentrantLock(true);
    }

    public int next() throws OrmException {
        this.counterLock.lock();
        try {
            if (this.counter >= this.limit) {
                this.acquire(this.batchSize);
            }
            int n = this.counter++;
            return n;
        }
        finally {
            this.counterLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<Integer> next(int count) throws OrmException {
        if (count == 0) {
            return ImmutableList.of();
        }
        Preconditions.checkArgument(count > 0, "count is negative: %s", count);
        this.counterLock.lock();
        try {
            ArrayList<Integer> ids = new ArrayList<Integer>(count);
            while (this.counter < this.limit) {
                ids.add(this.counter++);
                if (ids.size() != count) continue;
                ImmutableList<Integer> immutableList = ImmutableList.copyOf(ids);
                return immutableList;
            }
            this.acquire(Math.max(count - ids.size(), this.batchSize));
            while (ids.size() < count) {
                ids.add(this.counter++);
            }
            ImmutableList<Integer> immutableList = ImmutableList.copyOf(ids);
            return immutableList;
        }
        finally {
            this.counterLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public void set(int val) throws OrmException {
        this.counterLock.lock();
        try {
            try (Repository repo = this.repoManager.openRepository(this.projectName);
                 RevWalk rw = new RevWalk(repo);){
                this.checkResult(this.store(repo, rw, null, val));
                this.counter = this.limit;
            }
            catch (IOException e) {
                throw new OrmException(e);
            }
        }
        finally {
            this.counterLock.unlock();
        }
    }

    private void acquire(int count) throws OrmException {
        try (Repository repo = this.repoManager.openRepository(this.projectName);
             RevWalk rw = new RevWalk(repo);){
            TryAcquire attempt = new TryAcquire(repo, rw, count);
            this.checkResult(this.retryer.call(attempt));
            this.counter = attempt.next;
            this.limit = this.counter + count;
            ++this.acquireCount;
        }
        catch (RetryException | ExecutionException e) {
            if (e.getCause() != null) {
                Throwables.throwIfInstanceOf(e.getCause(), OrmException.class);
            }
            throw new OrmException(e);
        }
        catch (IOException e) {
            throw new OrmException(e);
        }
    }

    private void checkResult(RefUpdate.Result result) throws OrmException {
        if (result != RefUpdate.Result.NEW && result != RefUpdate.Result.FORCED) {
            throw new OrmException("failed to update " + this.refName + ": " + (Object)((Object)result));
        }
    }

    private RefUpdate.Result store(Repository repo, RevWalk rw, @Nullable ObjectId oldId, int val) throws IOException {
        ObjectId newId;
        try (ObjectInserter ins = repo.newObjectInserter();){
            newId = ins.insert(3, Integer.toString(val).getBytes(StandardCharsets.UTF_8));
            ins.flush();
        }
        RefUpdate ru = repo.updateRef(this.refName);
        if (oldId != null) {
            ru.setExpectedOldObjectId(oldId);
        }
        ru.setNewObjectId(newId);
        ru.setForceUpdate(true);
        return ru.update(rw);
    }

    public static ReceiveCommand storeNew(ObjectInserter ins, String name, int val) throws IOException {
        ObjectId newId = ins.insert(3, Integer.toString(val).getBytes(StandardCharsets.UTF_8));
        return new ReceiveCommand(ObjectId.zeroId(), newId, "refs/sequences/" + name);
    }

    private class TryAcquire
    implements Callable<RefUpdate.Result> {
        private final Repository repo;
        private final RevWalk rw;
        private final int count;
        private int next;

        private TryAcquire(Repository repo, RevWalk rw, int count) {
            this.repo = repo;
            this.rw = rw;
            this.count = count;
        }

        @Override
        public RefUpdate.Result call() throws Exception {
            ObjectId oldId;
            Ref ref = this.repo.exactRef(RepoSequence.this.refName);
            RepoSequence.this.afterReadRef.run();
            if (ref == null) {
                oldId = ObjectId.zeroId();
                this.next = RepoSequence.this.seed.get();
            } else {
                oldId = ref.getObjectId();
                this.next = this.parse(oldId);
            }
            return RepoSequence.this.store(this.repo, this.rw, oldId, this.next + this.count);
        }

        private int parse(ObjectId id) throws IOException, OrmException {
            ObjectLoader ol = this.rw.getObjectReader().open(id, 3);
            if (ol.getType() != 3) {
                throw new IncorrectObjectTypeException(id, 3);
            }
            String str = CharMatcher.whitespace().trimFrom(new String(ol.getCachedBytes(), StandardCharsets.UTF_8));
            Integer val = Ints.tryParse(str);
            if (val == null) {
                throw new OrmException("invalid value in " + RepoSequence.this.refName + " blob at " + id.name());
            }
            return val;
        }
    }

    public static interface Seed {
        public int get() throws OrmException;
    }
}

