/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.notedb.rebuild;

import com.google.common.base.MoreObjects;
import com.google.gerrit.reviewdb.client.PatchSetApproval;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.rebuild.Event;
import java.sql.Timestamp;

class ApprovalEvent
extends Event {
    private PatchSetApproval psa;

    ApprovalEvent(PatchSetApproval psa, Timestamp changeCreatedOn) {
        super(psa.getPatchSetId(), psa.getAccountId(), psa.getRealAccountId(), psa.getGranted(), changeCreatedOn, psa.getTag());
        this.psa = psa;
    }

    @Override
    boolean uniquePerUpdate() {
        return false;
    }

    @Override
    protected boolean canHaveTag() {
        return !this.psa.isLegacySubmit();
    }

    @Override
    void apply(ChangeUpdate update) {
        this.checkUpdate(update);
        update.putApproval(this.psa.getLabel(), this.psa.getValue());
    }

    @Override
    protected boolean isPostSubmitApproval() {
        return this.psa.isPostSubmit();
    }

    @Override
    protected void addToString(MoreObjects.ToStringHelper helper) {
        helper.add("approval", this.psa);
    }
}

