/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.ChildCollection;
import com.google.gerrit.extensions.restapi.IdString;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestView;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.BranchResource;
import com.google.gerrit.server.project.FileResource;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import org.eclipse.jgit.lib.ObjectId;

@Singleton
public class FilesCollection
implements ChildCollection<BranchResource, FileResource> {
    private final DynamicMap<RestView<FileResource>> views;
    private final GitRepositoryManager repoManager;

    @Inject
    FilesCollection(DynamicMap<RestView<FileResource>> views, GitRepositoryManager repoManager) {
        this.views = views;
        this.repoManager = repoManager;
    }

    @Override
    public RestView<BranchResource> list() throws ResourceNotFoundException {
        throw new ResourceNotFoundException();
    }

    @Override
    public FileResource parse(BranchResource parent, IdString id) throws ResourceNotFoundException, IOException {
        return FileResource.create(this.repoManager, parent.getControl(), ObjectId.fromString(parent.getRevision()), id.get());
    }

    @Override
    public DynamicMap<RestView<FileResource>> views() {
        return this.views;
    }
}

