/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.project.DashboardsCollection;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.ProjectResource;
import com.google.gerrit.server.project.ProjectState;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.BlobBasedConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ListDashboards
implements RestReadView<ProjectResource> {
    private static final Logger log = LoggerFactory.getLogger(ListDashboards.class);
    private final GitRepositoryManager gitManager;
    @Option(name="--inherited", usage="include inherited dashboards")
    private boolean inherited;

    @Inject
    ListDashboards(GitRepositoryManager gitManager) {
        this.gitManager = gitManager;
    }

    public List<?> apply(ProjectResource resource) throws ResourceNotFoundException, IOException {
        ProjectControl ctl = resource.getControl();
        String project = ctl.getProject().getName();
        if (!this.inherited) {
            return this.scan(resource.getControl(), project, true);
        }
        ArrayList<List<DashboardsCollection.DashboardInfo>> all = new ArrayList<List<DashboardsCollection.DashboardInfo>>();
        boolean setDefault = true;
        for (ProjectState ps : ctl.getProjectState().tree()) {
            ctl = ps.controlFor(ctl.getUser());
            if (!ctl.isVisible()) continue;
            List<DashboardsCollection.DashboardInfo> list = this.scan(ctl, project, setDefault);
            for (DashboardsCollection.DashboardInfo d : list) {
                if (d.isDefault == null || !Boolean.TRUE.equals(d.isDefault)) continue;
                setDefault = false;
            }
            if (list.isEmpty()) continue;
            all.add(list);
        }
        return all;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private List<DashboardsCollection.DashboardInfo> scan(ProjectControl ctl, String project, boolean setDefault) throws ResourceNotFoundException, IOException {
        Project.NameKey projectName = ctl.getProject().getNameKey();
        try {
            Throwable throwable = null;
            try (Repository git = this.gitManager.openRepository(projectName);){
                ArrayList<DashboardsCollection.DashboardInfo> arrayList;
                RevWalk rw = new RevWalk(git);
                Throwable throwable2 = null;
                try {
                    ArrayList<DashboardsCollection.DashboardInfo> all = new ArrayList<DashboardsCollection.DashboardInfo>();
                    for (Ref ref : git.getRefDatabase().getRefs("refs/meta/dashboards/").values()) {
                        if (!ctl.controlForRef(ref.getName()).isVisible()) continue;
                        all.addAll(this.scanDashboards(ctl.getProject(), git, rw, ref, project, setDefault));
                    }
                    arrayList = all;
                }
                catch (Throwable throwable3) {
                    try {
                        try {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        catch (Throwable throwable4) {
                            ListDashboards.$closeResource(throwable2, rw);
                            throw throwable4;
                        }
                    }
                    catch (Throwable throwable5) {
                        throwable = throwable5;
                        throw throwable5;
                    }
                }
                ListDashboards.$closeResource(throwable2, rw);
                return arrayList;
            }
        }
        catch (RepositoryNotFoundException e) {
            throw new ResourceNotFoundException();
        }
    }

    private List<DashboardsCollection.DashboardInfo> scanDashboards(Project definingProject, Repository git, RevWalk rw, Ref ref, String project, boolean setDefault) throws IOException {
        ArrayList<DashboardsCollection.DashboardInfo> list = new ArrayList<DashboardsCollection.DashboardInfo>();
        try (TreeWalk tw = new TreeWalk(rw.getObjectReader());){
            tw.addTree(rw.parseTree(ref.getObjectId()));
            tw.setRecursive(true);
            while (tw.next()) {
                if (tw.getFileMode(0) != FileMode.REGULAR_FILE) continue;
                try {
                    list.add(DashboardsCollection.parse(definingProject, ref.getName().substring("refs/meta/dashboards/".length()), tw.getPathString(), new BlobBasedConfig(null, git, tw.getObjectId(0)), project, setDefault));
                }
                catch (ConfigInvalidException e) {
                    log.warn("Cannot parse dashboard {}:{}:{}: {}", definingProject.getName(), ref.getName(), tw.getPathString(), e.getMessage());
                }
            }
        }
        return list;
    }
}

