/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.project;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.common.ProjectInfo;
import com.google.gerrit.extensions.common.WebLinkInfo;
import com.google.gerrit.extensions.restapi.Url;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.WebLinks;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.project.ProjectResource;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.List;

@Singleton
public class ProjectJson {
    private final AllProjectsName allProjects;
    private final WebLinks webLinks;

    @Inject
    ProjectJson(AllProjectsName allProjectsName, WebLinks webLinks) {
        this.allProjects = allProjectsName;
        this.webLinks = webLinks;
    }

    public ProjectInfo format(ProjectResource rsrc) {
        return this.format(rsrc.getControl().getProject());
    }

    public ProjectInfo format(Project p) {
        ProjectInfo info = new ProjectInfo();
        info.name = p.getName();
        Project.NameKey parentName = p.getParent(this.allProjects);
        info.parent = parentName != null ? parentName.get() : null;
        info.description = Strings.emptyToNull(p.getDescription());
        info.state = p.getState();
        info.id = Url.encode(info.name);
        List<WebLinkInfo> links = this.webLinks.getProjectLinks(p.getName());
        info.webLinks = links.isEmpty() ? null : links;
        return info;
    }
}

