/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.account;

import com.google.common.collect.Lists;
import com.google.common.primitives.Ints;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.account.AccountState;
import com.google.gerrit.server.index.FieldDef;
import com.google.gerrit.server.index.IndexPredicate;
import com.google.gerrit.server.index.account.AccountField;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.query.Matchable;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryBuilder;
import com.google.gerrit.server.query.account.AccountQueryBuilder;
import com.google.gerrit.server.query.account.CanSeeChangePredicate;
import com.google.gwtorm.server.OrmException;
import java.util.ArrayList;

public class AccountPredicates {
    public static boolean hasActive(Predicate<AccountState> p) {
        return QueryBuilder.find(p, AccountPredicate.class, AccountField.ACTIVE.getName()) != null;
    }

    static Predicate<AccountState> defaultPredicate(String query) {
        ArrayList<Predicate<AccountState>> preds = Lists.newArrayListWithCapacity(3);
        Integer id = Ints.tryParse(query);
        if (id != null) {
            preds.add(AccountPredicates.id(new Account.Id(id)));
        }
        preds.add(AccountPredicates.equalsName(query));
        preds.add(AccountPredicates.username(query));
        return Predicate.or(preds);
    }

    public static Predicate<AccountState> id(Account.Id accountId) {
        return new AccountPredicate(AccountField.ID, "account", accountId.toString());
    }

    static Predicate<AccountState> email(String email) {
        return new AccountPredicate(AccountField.EMAIL, "email", email.toLowerCase());
    }

    static Predicate<AccountState> equalsName(String name) {
        return new AccountPredicate(AccountField.NAME_PART, "name", name.toLowerCase());
    }

    static Predicate<AccountState> externalId(String externalId) {
        return new AccountPredicate(AccountField.EXTERNAL_ID, externalId);
    }

    static Predicate<AccountState> fullName(String fullName) {
        return new AccountPredicate(AccountField.FULL_NAME, fullName);
    }

    public static Predicate<AccountState> isActive() {
        return new AccountPredicate(AccountField.ACTIVE, "1");
    }

    static Predicate<AccountState> isInactive() {
        return new AccountPredicate(AccountField.ACTIVE, "0");
    }

    static Predicate<AccountState> username(String username) {
        return new AccountPredicate(AccountField.USERNAME, "username", username.toLowerCase());
    }

    static Predicate<AccountState> watchedProject(Project.NameKey project) {
        return new AccountPredicate(AccountField.WATCHED_PROJECT, project.get());
    }

    static Predicate<AccountState> cansee(AccountQueryBuilder.Arguments args, ChangeNotes changeNotes) {
        return new CanSeeChangePredicate(args.db, args.changeControlFactory, args.userFactory, changeNotes);
    }

    private AccountPredicates() {
    }

    static class AccountPredicate
    extends IndexPredicate<AccountState>
    implements Matchable<AccountState> {
        AccountPredicate(FieldDef<AccountState, ?> def, String value) {
            super(def, value);
        }

        AccountPredicate(FieldDef<AccountState, ?> def, String name, String value) {
            super(def, name, value);
        }

        @Override
        public boolean match(AccountState object) throws OrmException {
            return true;
        }

        @Override
        public int getCost() {
            return 1;
        }
    }
}

