/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.query.change;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeIndexPredicate;
import com.google.gwtorm.server.OrmException;
import java.util.ArrayList;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;

public final class ChangeStatusPredicate
extends ChangeIndexPredicate {
    private static final TreeMap<String, Predicate<ChangeData>> PREDICATES = new TreeMap();
    private static final Predicate<ChangeData> CLOSED;
    private static final Predicate<ChangeData> OPEN;
    private final Change.Status status;

    public static String canonicalize(Change.Status status) {
        return status.name().toLowerCase();
    }

    public static Predicate<ChangeData> parse(String value) throws QueryParseException {
        Map.Entry e;
        String lower = value.toLowerCase();
        NavigableMap<String, Predicate<ChangeData>> head = PREDICATES.tailMap(lower, true);
        if (!head.isEmpty() && ((String)(e = head.entrySet().iterator().next()).getKey()).startsWith(lower)) {
            return (Predicate)e.getValue();
        }
        throw new QueryParseException("invalid change status: " + value);
    }

    public static Predicate<ChangeData> open() {
        return OPEN;
    }

    public static Predicate<ChangeData> closed() {
        return CLOSED;
    }

    ChangeStatusPredicate(Change.Status status) {
        super(ChangeField.STATUS, ChangeStatusPredicate.canonicalize(status));
        this.status = status;
    }

    public Change.Status getStatus() {
        return this.status;
    }

    @Override
    public boolean match(ChangeData object) throws OrmException {
        Change change = object.change();
        return change != null && this.status.equals((Object)change.getStatus());
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public int hashCode() {
        return this.status.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof ChangeStatusPredicate) {
            ChangeStatusPredicate p = (ChangeStatusPredicate)other;
            return this.status.equals((Object)p.status);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getOperator() + ":" + this.getValue();
    }

    static {
        ArrayList<ChangeStatusPredicate> open = new ArrayList<ChangeStatusPredicate>();
        ArrayList closed = new ArrayList();
        for (Change.Status s : Change.Status.values()) {
            ChangeStatusPredicate p = new ChangeStatusPredicate(s);
            PREDICATES.put(ChangeStatusPredicate.canonicalize(s), p);
            (s.isOpen() ? open : closed).add(p);
        }
        CLOSED = Predicate.or(closed);
        OPEN = Predicate.or(open);
        PREDICATES.put("closed", CLOSED);
        PREDICATES.put("open", OPEN);
        PREDICATES.put("pending", OPEN);
    }
}

