/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.schema.DataSourceType;
import com.google.gerrit.server.schema.ScriptRunner;
import java.io.IOException;
import java.io.InputStream;

public abstract class BaseDataSourceType
implements DataSourceType {
    private static final String DEFAULT_VALIDATION_QUERY = "select 1";
    private final String driver;

    protected BaseDataSourceType(String driver) {
        this.driver = driver;
    }

    @Override
    public final String getDriver() {
        return this.driver;
    }

    @Override
    public boolean usePool() {
        return true;
    }

    @Override
    public String getValidationQuery() {
        return DEFAULT_VALIDATION_QUERY;
    }

    @Override
    public ScriptRunner getIndexScript() throws IOException {
        return BaseDataSourceType.getScriptRunner("index_generic.sql");
    }

    protected static final ScriptRunner getScriptRunner(String path) throws IOException {
        ScriptRunner runner;
        if (path == null) {
            return ScriptRunner.NOOP;
        }
        try (InputStream in = ReviewDb.class.getResourceAsStream(path);){
            if (in == null) {
                throw new IllegalStateException("SQL script " + path + " not found");
            }
            runner = new ScriptRunner(path, in);
        }
        return runner;
    }
}

