/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.schema;

import com.google.common.primitives.Ints;
import com.google.gerrit.extensions.events.LifecycleListener;
import com.google.gerrit.extensions.registration.DynamicItem;
import com.google.gerrit.lifecycle.LifecycleModule;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.server.change.AccountPatchReviewStore;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.config.ThreadSettingsConfig;
import com.google.gerrit.server.schema.H2;
import com.google.gerrit.server.schema.H2AccountPatchReviewStore;
import com.google.gerrit.server.schema.MariaDBAccountPatchReviewStore;
import com.google.gerrit.server.schema.MysqlAccountPatchReviewStore;
import com.google.gerrit.server.schema.PostgresqlAccountPatchReviewStore;
import com.google.gwtorm.server.OrmDuplicateKeyException;
import com.google.gwtorm.server.OrmException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JdbcAccountPatchReviewStore
implements AccountPatchReviewStore,
LifecycleListener {
    private static final String ACCOUNT_PATCH_REVIEW_DB = "accountPatchReviewDb";
    private static final String H2_DB = "h2";
    private static final String MARIADB = "mariadb";
    private static final String MYSQL = "mysql";
    private static final String POSTGRESQL = "postgresql";
    private static final String URL = "url";
    private static final Logger log = LoggerFactory.getLogger(JdbcAccountPatchReviewStore.class);
    private DataSource ds;

    public static JdbcAccountPatchReviewStore createAccountPatchReviewStore(Config cfg, SitePaths sitePaths, ThreadSettingsConfig threadSettingsConfig) {
        String url = cfg.getString(ACCOUNT_PATCH_REVIEW_DB, null, URL);
        if (url == null || url.contains(H2_DB)) {
            return new H2AccountPatchReviewStore(cfg, sitePaths, threadSettingsConfig);
        }
        if (url.contains(POSTGRESQL)) {
            return new PostgresqlAccountPatchReviewStore(cfg, sitePaths, threadSettingsConfig);
        }
        if (url.contains(MYSQL)) {
            return new MysqlAccountPatchReviewStore(cfg, sitePaths, threadSettingsConfig);
        }
        if (url.contains(MARIADB)) {
            return new MariaDBAccountPatchReviewStore(cfg, sitePaths, threadSettingsConfig);
        }
        throw new IllegalArgumentException("unsupported driver type for account patch reviews db: " + url);
    }

    protected JdbcAccountPatchReviewStore(Config cfg, SitePaths sitePaths, ThreadSettingsConfig threadSettingsConfig) {
        this.ds = JdbcAccountPatchReviewStore.createDataSource(cfg, sitePaths, threadSettingsConfig);
    }

    protected JdbcAccountPatchReviewStore(DataSource ds) {
        this.ds = ds;
    }

    private static String getUrl(@GerritServerConfig Config cfg, SitePaths sitePaths) {
        String url = cfg.getString(ACCOUNT_PATCH_REVIEW_DB, null, URL);
        if (url == null) {
            return H2.createUrl(sitePaths.db_dir.resolve("account_patch_reviews"));
        }
        return url;
    }

    private static DataSource createDataSource(Config cfg, SitePaths sitePaths, ThreadSettingsConfig threadSettingsConfig) {
        BasicDataSource datasource = new BasicDataSource();
        String url = JdbcAccountPatchReviewStore.getUrl(cfg, sitePaths);
        int poolLimit = threadSettingsConfig.getDatabasePoolLimit();
        datasource.setUrl(url);
        datasource.setDriverClassName(JdbcAccountPatchReviewStore.getDriverFromUrl(url));
        datasource.setMaxActive(cfg.getInt(ACCOUNT_PATCH_REVIEW_DB, "poolLimit", poolLimit));
        datasource.setMinIdle(cfg.getInt(ACCOUNT_PATCH_REVIEW_DB, "poolminidle", 4));
        datasource.setMaxIdle(cfg.getInt(ACCOUNT_PATCH_REVIEW_DB, "poolmaxidle", Math.min(poolLimit, 16)));
        datasource.setInitialSize(datasource.getMinIdle());
        datasource.setMaxWait(ConfigUtil.getTimeUnit(cfg, ACCOUNT_PATCH_REVIEW_DB, null, "poolmaxwait", TimeUnit.MILLISECONDS.convert(30L, TimeUnit.SECONDS), TimeUnit.MILLISECONDS));
        long evictIdleTimeMs = 60000L;
        datasource.setMinEvictableIdleTimeMillis(evictIdleTimeMs);
        datasource.setTimeBetweenEvictionRunsMillis(evictIdleTimeMs / 2L);
        return datasource;
    }

    private static String getDriverFromUrl(String url) {
        if (url.contains(POSTGRESQL)) {
            return "org.postgresql.Driver";
        }
        if (url.contains(MYSQL)) {
            return "com.mysql.jdbc.Driver";
        }
        if (url.contains(MARIADB)) {
            return "org.mariadb.jdbc.Driver";
        }
        return "org.h2.Driver";
    }

    @Override
    public void start() {
        try {
            this.createTableIfNotExists();
        }
        catch (OrmException e) {
            log.error("Failed to create table to store account patch reviews", e);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    public void createTableIfNotExists() throws OrmException {
        try (Connection con = this.ds.getConnection();
             Statement stmt = con.createStatement();){
            this.doCreateTable(stmt);
        }
        catch (SQLException e) {
            throw this.convertError("create", e);
        }
    }

    protected void doCreateTable(Statement stmt) throws SQLException {
        stmt.executeUpdate("CREATE TABLE IF NOT EXISTS account_patch_reviews (account_id INTEGER DEFAULT 0 NOT NULL, change_id INTEGER DEFAULT 0 NOT NULL, patch_set_id INTEGER DEFAULT 0 NOT NULL, file_name VARCHAR(4096) DEFAULT '' NOT NULL, CONSTRAINT primary_key_account_patch_reviews PRIMARY KEY (change_id, patch_set_id, account_id, file_name))");
    }

    public void dropTableIfExists() throws OrmException {
        try (Connection con = this.ds.getConnection();
             Statement stmt = con.createStatement();){
            stmt.executeUpdate("DROP TABLE IF EXISTS account_patch_reviews");
        }
        catch (SQLException e) {
            throw this.convertError("create", e);
        }
    }

    @Override
    public void stop() {
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean markReviewed(PatchSet.Id psId, Account.Id accountId, String path) throws OrmException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void markReviewed(PatchSet.Id psId, Account.Id accountId, Collection<String> paths) throws OrmException {
        if (paths == null || paths.isEmpty()) {
            return;
        }
        try (Connection con = this.ds.getConnection();
             PreparedStatement stmt = con.prepareStatement("INSERT INTO account_patch_reviews (account_id, change_id, patch_set_id, file_name) VALUES (?, ?, ?, ?)");){
            for (String path : paths) {
                stmt.setInt(1, accountId.get());
                stmt.setInt(2, psId.getParentKey().get());
                stmt.setInt(3, psId.get());
                stmt.setString(4, path);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            OrmException ormException = this.convertError("insert", e);
            if (ormException instanceof OrmDuplicateKeyException) {
                return;
            }
            throw ormException;
        }
    }

    @Override
    public void clearReviewed(PatchSet.Id psId, Account.Id accountId, String path) throws OrmException {
        try (Connection con = this.ds.getConnection();
             PreparedStatement stmt = con.prepareStatement("DELETE FROM account_patch_reviews WHERE account_id = ? AND change_id = ? AND patch_set_id = ? AND file_name = ?");){
            stmt.setInt(1, accountId.get());
            stmt.setInt(2, psId.getParentKey().get());
            stmt.setInt(3, psId.get());
            stmt.setString(4, path);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw this.convertError("delete", e);
        }
    }

    @Override
    public void clearReviewed(PatchSet.Id psId) throws OrmException {
        try (Connection con = this.ds.getConnection();
             PreparedStatement stmt = con.prepareStatement("DELETE FROM account_patch_reviews WHERE change_id = ? AND patch_set_id = ?");){
            stmt.setInt(1, psId.getParentKey().get());
            stmt.setInt(2, psId.get());
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            throw this.convertError("delete", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Optional<AccountPatchReviewStore.PatchSetWithReviewedFiles> findReviewed(PatchSet.Id psId, Account.Id accountId) throws OrmException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 5 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public OrmException convertError(String op, SQLException err) {
        if (err.getCause() == null && err.getNextException() != null) {
            err.initCause(err.getNextException());
        }
        return new OrmException(op + " failure on account_patch_reviews", err);
    }

    private static String getSQLState(SQLException err) {
        String ec;
        SQLException next = err;
        do {
            ec = next.getSQLState();
            next = next.getNextException();
        } while (ec == null && next != null);
        return ec;
    }

    protected static int getSQLStateInt(SQLException err) {
        String s = JdbcAccountPatchReviewStore.getSQLState(err);
        if (s != null) {
            Integer i = Ints.tryParse(s);
            return i != null ? i : -1;
        }
        return 0;
    }

    public static class Module
    extends LifecycleModule {
        private final Config cfg;

        public Module(Config cfg) {
            this.cfg = cfg;
        }

        @Override
        protected void configure() {
            Class impl;
            String url = this.cfg.getString(JdbcAccountPatchReviewStore.ACCOUNT_PATCH_REVIEW_DB, null, JdbcAccountPatchReviewStore.URL);
            if (url == null || url.contains(JdbcAccountPatchReviewStore.H2_DB)) {
                impl = H2AccountPatchReviewStore.class;
            } else if (url.contains(JdbcAccountPatchReviewStore.POSTGRESQL)) {
                impl = PostgresqlAccountPatchReviewStore.class;
            } else if (url.contains(JdbcAccountPatchReviewStore.MYSQL)) {
                impl = MysqlAccountPatchReviewStore.class;
            } else if (url.contains(JdbcAccountPatchReviewStore.MARIADB)) {
                impl = MariaDBAccountPatchReviewStore.class;
            } else {
                throw new IllegalArgumentException("unsupported driver type for account patch reviews db: " + url);
            }
            DynamicItem.bind(this.binder(), AccountPatchReviewStore.class).to(impl);
            this.listener().to(impl);
        }
    }
}

