/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.InternalUser;
import com.google.gerrit.server.util.ManualRequestContext;
import com.google.gerrit.server.util.ThreadLocalRequestContext;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;

@Singleton
public class OneOffRequestContext {
    private final InternalUser.Factory userFactory;
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final ThreadLocalRequestContext requestContext;
    private final IdentifiedUser.GenericFactory identifiedUserFactory;

    @Inject
    OneOffRequestContext(InternalUser.Factory userFactory, SchemaFactory<ReviewDb> schemaFactory, ThreadLocalRequestContext requestContext, IdentifiedUser.GenericFactory identifiedUserFactory) {
        this.userFactory = userFactory;
        this.schemaFactory = schemaFactory;
        this.requestContext = requestContext;
        this.identifiedUserFactory = identifiedUserFactory;
    }

    public ManualRequestContext open() throws OrmException {
        return new ManualRequestContext(this.userFactory.create(), this.schemaFactory, this.requestContext);
    }

    public ManualRequestContext openAs(Account.Id userId) throws OrmException {
        return new ManualRequestContext(this.identifiedUserFactory.create(userId), this.schemaFactory, this.requestContext);
    }
}

