/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.util;

import com.google.common.base.MoreObjects;
import com.google.gerrit.common.Nullable;
import com.google.gerrit.common.errors.NotSignedInException;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.util.FallbackRequestContext;
import com.google.gerrit.server.util.RequestContext;
import com.google.inject.AbstractModule;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.inject.ProvisionException;
import com.google.inject.name.Named;
import com.google.inject.name.Names;

public class ThreadLocalRequestContext {
    private static final String FALLBACK = "FALLBACK";
    private static final ThreadLocal<RequestContext> local = new ThreadLocal();

    public static Module module() {
        return new AbstractModule(){

            @Override
            protected void configure() {
                this.bind(ThreadLocalRequestContext.class);
                this.bind(RequestContext.class).annotatedWith(Names.named(ThreadLocalRequestContext.FALLBACK)).to(FallbackRequestContext.class);
            }

            @Provides
            RequestContext provideRequestContext(@Named(value="FALLBACK") RequestContext fallback) {
                return MoreObjects.firstNonNull((RequestContext)local.get(), fallback);
            }

            @Provides
            CurrentUser provideCurrentUser(RequestContext ctx) {
                return ctx.getUser();
            }

            @Provides
            IdentifiedUser provideCurrentUser(CurrentUser user) {
                if (user.isIdentifiedUser()) {
                    return user.asIdentifiedUser();
                }
                throw new ProvisionException("Not Signed In", new NotSignedInException());
            }

            @Provides
            ReviewDb provideReviewDb(RequestContext ctx) {
                return ctx.getReviewDbProvider().get();
            }
        };
    }

    @Inject
    ThreadLocalRequestContext() {
    }

    public RequestContext setContext(@Nullable RequestContext ctx) {
        RequestContext old = this.getContext();
        local.set(ctx);
        return old;
    }

    @Nullable
    public RequestContext getContext() {
        return local.get();
    }
}

