/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd;

import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeFinder;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.ChangesCollection;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchChangeException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ChangeArgumentParser {
    private final CurrentUser currentUser;
    private final ChangesCollection changesCollection;
    private final ChangeFinder changeFinder;
    private final ReviewDb db;
    private final ChangeNotes.Factory changeNotesFactory;
    private final ChangeControl.GenericFactory changeControlFactory;

    @Inject
    ChangeArgumentParser(CurrentUser currentUser, ChangesCollection changesCollection, ChangeFinder changeFinder, ReviewDb db, ChangeNotes.Factory changeNotesFactory, ChangeControl.GenericFactory changeControlFactory) {
        this.currentUser = currentUser;
        this.changesCollection = changesCollection;
        this.changeFinder = changeFinder;
        this.db = db;
        this.changeNotesFactory = changeNotesFactory;
        this.changeControlFactory = changeControlFactory;
    }

    public void addChange(String id, Map<Change.Id, ChangeResource> changes) throws BaseCommand.UnloggedFailure, OrmException {
        this.addChange(id, changes, null);
    }

    public void addChange(String id, Map<Change.Id, ChangeResource> changes, ProjectControl projectControl) throws BaseCommand.UnloggedFailure, OrmException {
        this.addChange(id, changes, projectControl, true);
    }

    public void addChange(String id, Map<Change.Id, ChangeResource> changes, ProjectControl projectControl, boolean useIndex) throws BaseCommand.UnloggedFailure, OrmException {
        List<ChangeControl> matched = useIndex ? this.changeFinder.find(id, this.currentUser) : this.changeFromNotesFactory(id, this.currentUser);
        ArrayList<ChangeControl> toAdd = new ArrayList<ChangeControl>(changes.size());
        boolean canMaintainServer = this.currentUser.isIdentifiedUser() && this.currentUser.asIdentifiedUser().getCapabilities().canMaintainServer();
        for (ChangeControl ctl : matched) {
            if (changes.containsKey(ctl.getId()) || !this.inProject(projectControl, ctl.getProject()) || !canMaintainServer && !ctl.isVisible(this.db)) continue;
            toAdd.add(ctl);
        }
        if (toAdd.isEmpty()) {
            throw new BaseCommand.UnloggedFailure(1, "\"" + id + "\" no such change");
        }
        if (toAdd.size() > 1) {
            throw new BaseCommand.UnloggedFailure(1, "\"" + id + "\" matches multiple changes");
        }
        ChangeControl ctl = (ChangeControl)toAdd.get(0);
        changes.put(ctl.getId(), this.changesCollection.parse(ctl));
    }

    private List<ChangeControl> changeFromNotesFactory(String id, CurrentUser currentUser) throws OrmException, BaseCommand.UnloggedFailure {
        return this.changeNotesFactory.create(this.db, this.parseId(id)).stream().map(changeNote -> this.controlForChange((ChangeNotes)changeNote, currentUser)).filter(changeControl -> changeControl.isPresent()).map(changeControl -> (ChangeControl)changeControl.get()).collect(Collectors.toList());
    }

    private List<Change.Id> parseId(String id) throws BaseCommand.UnloggedFailure {
        try {
            return Arrays.asList(new Change.Id(Integer.parseInt(id)));
        }
        catch (NumberFormatException e) {
            throw new BaseCommand.UnloggedFailure(2, "Invalid change ID " + id, e);
        }
    }

    private Optional<ChangeControl> controlForChange(ChangeNotes change, CurrentUser user) {
        try {
            return Optional.of(this.changeControlFactory.controlFor(change, user));
        }
        catch (NoSuchChangeException e) {
            return Optional.empty();
        }
    }

    private boolean inProject(ProjectControl projectControl, Project project) {
        if (projectControl != null) {
            return projectControl.getProject().getNameKey().equals(project.getNameKey());
        }
        return true;
    }
}

