/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.sshd.commands;

import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.server.change.ChangeResource;
import com.google.gerrit.server.change.Index;
import com.google.gerrit.sshd.BaseCommand;
import com.google.gerrit.sshd.ChangeArgumentParser;
import com.google.gerrit.sshd.CommandMetaData;
import com.google.gerrit.sshd.SshCommand;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.kohsuke.args4j.Argument;

@CommandMetaData(name="changes", description="Index changes")
final class IndexChangesCommand
extends SshCommand {
    @Inject
    private Index index;
    @Inject
    private ChangeArgumentParser changeArgumentParser;
    private Map<Change.Id, ChangeResource> changes = new LinkedHashMap<Change.Id, ChangeResource>();

    IndexChangesCommand() {
    }

    @Argument(index=0, required=true, multiValued=true, metaVar="CHANGE", usage="changes to index")
    void addChange(String token) {
        try {
            this.changeArgumentParser.addChange(token, this.changes, null, false);
        }
        catch (BaseCommand.UnloggedFailure | OrmException e) {
            this.writeError("warning", e.getMessage());
        }
    }

    @Override
    protected void run() throws BaseCommand.UnloggedFailure {
        boolean ok = true;
        for (ChangeResource rsrc : this.changes.values()) {
            try {
                this.index.apply(rsrc, new Index.Input());
            }
            catch (RestApiException | OrmException | IOException e) {
                ok = false;
                this.writeError("error", String.format("failed to index change %s: %s", rsrc.getId(), e.getMessage()));
            }
        }
        if (!ok) {
            throw this.die("failed to index one or more changes");
        }
    }
}

