/*
 * Decompiled with CFR 0.152.
 */
package com.google.gitiles.blame;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gitiles.blame.BlameCache;
import com.google.gitiles.blame.Region;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.eclipse.jgit.blame.BlameGenerator;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.jgit.treewalk.filter.AndTreeFilter;
import org.eclipse.jgit.treewalk.filter.PathFilterGroup;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.QuotedString;

public class BlameCacheImpl
implements BlameCache {
    private final Cache<Key, List<Region>> cache;

    public static CacheBuilder<Key, List<Region>> defaultBuilder() {
        return BlameCacheImpl.weigher(CacheBuilder.newBuilder()).maximumWeight(10240L);
    }

    public static CacheBuilder<Key, List<Region>> weigher(CacheBuilder<? super Key, ? super List<Region>> cacheBuilder) {
        return cacheBuilder.weigher((key, list) -> list.size());
    }

    public BlameCacheImpl() {
        this(BlameCacheImpl.defaultBuilder());
    }

    public Cache<Key, List<Region>> getCache() {
        return this.cache;
    }

    public Callable<List<Region>> newLoader(Key key, Repository repository) {
        return () -> BlameCacheImpl.loadBlame(key, repository);
    }

    public BlameCacheImpl(CacheBuilder<? super Key, ? super List<Region>> cacheBuilder) {
        this.cache = cacheBuilder.build();
    }

    @Override
    public List<Region> get(Repository repository, ObjectId objectId, String string) throws IOException {
        try {
            Key key = new Key(objectId, string);
            return this.cache.get(key, this.newLoader(key, repository));
        }
        catch (ExecutionException executionException) {
            throw new IOException(executionException);
        }
    }

    @Override
    public ObjectId findLastCommit(Repository repository, ObjectId objectId, String string) throws IOException {
        try (RevWalk revWalk = new RevWalk(repository);){
            revWalk.markStart(revWalk.parseCommit(objectId));
            revWalk.setRewriteParents(false);
            revWalk.setTreeFilter(AndTreeFilter.create(PathFilterGroup.createFromStrings(string), TreeFilter.ANY_DIFF));
            RevCommit revCommit = revWalk.next();
            return revCommit;
        }
    }

    public static List<Region> loadBlame(Key key, Repository repository) throws IOException {
        try (BlameGenerator blameGenerator = new BlameGenerator(repository, key.path);){
            blameGenerator.push(null, key.commitId);
            List<Region> list = BlameCacheImpl.loadRegions(blameGenerator);
            return list;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static List<Region> loadRegions(BlameGenerator blameGenerator) throws IOException {
        Serializable object;
        Object object2;
        HashMap<ObjectId, PooledCommit> hashMap = Maps.newHashMap();
        Interner<Object> interner = Interners.newStrongInterner();
        int n = blameGenerator.getResultContents().size();
        ArrayList<Region> arrayList = Lists.newArrayList();
        while (blameGenerator.next()) {
            void object4;
            object2 = blameGenerator.getSourcePath();
            object = blameGenerator.getSourceAuthor();
            Object object3 = blameGenerator.getSourceCommit();
            Preconditions.checkState(object2 != null && object != null && object3 != null);
            PooledCommit pooledCommit = (PooledCommit)hashMap.get(object3);
            if (pooledCommit == null) {
                PooledCommit pooledCommit2 = new PooledCommit(((AnyObjectId)object3).copy(), new PersonIdent(interner.intern(((PersonIdent)object).getName()), interner.intern(((PersonIdent)object).getEmailAddress()), ((PersonIdent)object).getWhen(), ((PersonIdent)object).getTimeZone()));
                hashMap.put(pooledCommit2.commit, pooledCommit2);
            }
            object2 = (String)interner.intern(object2);
            object3 = object4.commit;
            object = object4.author;
            arrayList.add(new Region((String)object2, (ObjectId)object3, (PersonIdent)object, blameGenerator.getResultStart(), blameGenerator.getResultEnd()));
        }
        Collections.sort(arrayList);
        object2 = Lists.newArrayListWithExpectedSize(arrayList.size());
        object = null;
        for (Region region : arrayList) {
            if (object != null) {
                Preconditions.checkState(((Region)object).getEnd() <= region.getStart());
                if (((Region)object).getEnd() < region.getStart()) {
                    object2.add(new Region(null, null, null, ((Region)object).getEnd(), region.getStart()));
                }
            }
            object2.add(region);
            object = region;
        }
        if (object != null && ((Region)object).getEnd() != n) {
            object2.add(new Region(null, null, null, ((Region)object).getEnd(), n));
        }
        return ImmutableList.copyOf(object2);
    }

    private static class PooledCommit {
        final ObjectId commit;
        final PersonIdent author;

        private PooledCommit(ObjectId objectId, PersonIdent personIdent) {
            this.commit = objectId;
            this.author = personIdent;
        }
    }

    public static class Key {
        private final ObjectId commitId;
        private final String path;

        public Key(ObjectId objectId, String string) {
            this.commitId = objectId;
            this.path = string;
        }

        public ObjectId getCommitId() {
            return this.commitId;
        }

        public String getPath() {
            return this.path;
        }

        public boolean equals(Object object) {
            if (object instanceof Key) {
                Key key = (Key)object;
                return Objects.equals(this.commitId, key.commitId) && Objects.equals(this.path, key.path);
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.commitId, this.path);
        }

        public String toString() {
            return this.commitId.name() + ":" + QuotedString.GIT_PATH.quote(this.path);
        }
    }
}

