/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.basetree.SyntaxVersionUpperBound;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;

final class ReportSyntaxVersionErrorsVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind SYNTAX_VERSION_OUT_OF_BOUNDS = SoyErrorKind.of("{0}: {1}");
    private final SyntaxVersion requiredSyntaxVersion;
    private final ErrorReporter errorReporter;
    private final String errorPreamble;

    ReportSyntaxVersionErrorsVisitor(SyntaxVersion requiredSyntaxVersion, boolean isDeclared, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.requiredSyntaxVersion = requiredSyntaxVersion;
        this.errorPreamble = requiredSyntaxVersion == SyntaxVersion.V1_0 ? "incorrect v1 syntax" : (isDeclared ? "declared" : "inferred") + " syntax version " + (Object)((Object)requiredSyntaxVersion) + " not satisfied";
    }

    @Override
    public Void exec(SoyNode node) {
        this.visitSoyNode(node);
        return null;
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (!node.couldHaveSyntaxVersionAtLeast(this.requiredSyntaxVersion)) {
            SyntaxVersionUpperBound syntaxVersionBound = node.getSyntaxVersionUpperBound();
            Preconditions.checkNotNull(syntaxVersionBound);
            this.errorReporter.report(node.getSourceLocation(), SYNTAX_VERSION_OUT_OF_BOUNDS, this.errorPreamble, syntaxVersionBound.reasonStr);
        }
        if (node instanceof SoyNode.ExprHolderNode) {
            for (ExprUnion exprUnion : ((SoyNode.ExprHolderNode)node).getAllExprUnions()) {
                if (exprUnion.getExpr() != null || this.requiredSyntaxVersion.num < SyntaxVersion.V2_0.num) continue;
                exprUnion.reportV2ParseErrors(this.errorReporter);
            }
        }
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

