/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.SoyNode;
import javax.annotation.Nullable;

public final class HtmlAttributeNode
extends AbstractParentSoyNode<SoyNode.StandaloneNode>
implements SoyNode.StandaloneNode,
SoyNode.BlockNode {
    @Nullable
    private final SourceLocation.Point equalsSignLocation;

    public HtmlAttributeNode(int id, SourceLocation location, @Nullable SourceLocation.Point equalsSignLocation) {
        super(id, location);
        this.equalsSignLocation = equalsSignLocation;
    }

    private HtmlAttributeNode(HtmlAttributeNode orig, CopyState copyState) {
        super(orig, copyState);
        this.equalsSignLocation = orig.equalsSignLocation;
    }

    public boolean hasValue() {
        return this.equalsSignLocation != null;
    }

    public SourceLocation getEqualsLocation() {
        Preconditions.checkState(this.equalsSignLocation != null, "This attribute doesn't have a value");
        return this.equalsSignLocation.asLocation(this.getSourceLocation().getFilePath());
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.HTML_ATTRIBUTE_NODE;
    }

    @Override
    public SoyNode copy(CopyState copyState) {
        return new HtmlAttributeNode(this, copyState);
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(((SoyNode.StandaloneNode)this.getChild(0)).toSourceString());
        if (this.hasValue()) {
            sb.append('=');
            sb.append(((SoyNode.StandaloneNode)this.getChild(1)).toSourceString());
        }
        return sb.toString();
    }

    @Override
    public SoyNode.BlockNode getParent() {
        return (SoyNode.BlockNode)super.getParent();
    }
}

