/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.config.keys;

import java.io.IOException;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.ClientIdentityProvider;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Pair;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.ModifiableFileWatcher;

public class ClientIdentityFileWatcher
extends ModifiableFileWatcher
implements ClientIdentityProvider {
    private final AtomicReference<KeyPair> identityHolder = new AtomicReference<Object>(null);
    private final Supplier<ClientIdentityLoader> loaderHolder;
    private final Supplier<FilePasswordProvider> providerHolder;
    private final boolean strict;

    public ClientIdentityFileWatcher(Path path, ClientIdentityLoader loader, FilePasswordProvider provider) {
        this(path, loader, provider, true);
    }

    public ClientIdentityFileWatcher(Path path, ClientIdentityLoader loader, FilePasswordProvider provider, boolean strict) {
        this(path, GenericUtils.supplierOf(Objects.requireNonNull(loader, "No client identity loader")), GenericUtils.supplierOf(Objects.requireNonNull(provider, "No password provider")), strict);
    }

    public ClientIdentityFileWatcher(Path path, Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider) {
        this(path, loader, provider, true);
    }

    public ClientIdentityFileWatcher(Path path, Supplier<ClientIdentityLoader> loader, Supplier<FilePasswordProvider> provider, boolean strict) {
        super(path);
        this.loaderHolder = Objects.requireNonNull(loader, "No client identity loader");
        this.providerHolder = Objects.requireNonNull(provider, "No password provider");
        this.strict = strict;
    }

    public final boolean isStrict() {
        return this.strict;
    }

    public final ClientIdentityLoader getClientIdentityLoader() {
        return this.loaderHolder.get();
    }

    public final FilePasswordProvider getFilePasswordProvider() {
        return this.providerHolder.get();
    }

    @Override
    public KeyPair getClientIdentity() throws IOException, GeneralSecurityException {
        if (this.checkReloadRequired()) {
            KeyPair kp = this.identityHolder.getAndSet(null);
            Path path = this.getPath();
            if (this.exists()) {
                KeyPair id = this.reloadClientIdentity(path);
                if (!KeyUtils.compareKeyPairs(kp, id) && this.log.isDebugEnabled()) {
                    this.log.debug("getClientIdentity({}) identity {}", (Object)path, (Object)(kp == null ? "loaded" : "re-loaded"));
                }
                this.updateReloadAttributes();
                this.identityHolder.set(id);
            }
        }
        return this.identityHolder.get();
    }

    protected KeyPair reloadClientIdentity(Path path) throws IOException, GeneralSecurityException {
        Pair<String, Object> violation;
        if (this.isStrict() && (violation = KeyUtils.validateStrictKeyFilePermissions(path, IoUtils.EMPTY_LINK_OPTIONS)) != null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("reloadClientIdentity({}) ignore due to {}", (Object)path, (Object)violation.getFirst());
            }
            return null;
        }
        String location = path.toString();
        ClientIdentityLoader idLoader = Objects.requireNonNull(this.getClientIdentityLoader(), "No client identity loader");
        if (idLoader.isValidLocation(location)) {
            KeyPair kp = idLoader.loadClientIdentity(location, Objects.requireNonNull(this.getFilePasswordProvider(), "No file password provider"));
            if (this.log.isTraceEnabled()) {
                PublicKey key;
                PublicKey publicKey = key = kp == null ? null : kp.getPublic();
                if (key != null) {
                    this.log.trace("reloadClientIdentity({}) loaded {}-{}", location, KeyUtils.getKeyType(key), KeyUtils.getFingerPrint(key));
                } else {
                    this.log.trace("reloadClientIdentity({}) no key loaded", (Object)location);
                }
            }
            return kp;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("reloadClientIdentity({}) invalid location", (Object)location);
        }
        return null;
    }
}

