/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StreamCorruptedException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.PublicKeyEntry;
import org.apache.sshd.common.config.keys.PublicKeyEntryDecoder;
import org.apache.sshd.common.config.keys.PublicKeyEntryResolver;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.io.NoCloseReader;
import org.apache.sshd.server.auth.pubkey.KeySetPublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.RejectAllPublickeyAuthenticator;

public class AuthorizedKeyEntry
extends PublicKeyEntry {
    private static final long serialVersionUID = -9007505285002809156L;
    private String comment;
    private Map<String, String> loginOptions = Collections.emptyMap();

    public String getComment() {
        return this.comment;
    }

    public void setComment(String value) {
        this.comment = value;
    }

    public Map<String, String> getLoginOptions() {
        return this.loginOptions;
    }

    public void setLoginOptions(Map<String, String> value) {
        this.loginOptions = value == null ? Collections.emptyMap() : value;
    }

    @Override
    public PublicKey appendPublicKey(Appendable sb, PublicKeyEntryResolver fallbackResolver) throws IOException, GeneralSecurityException {
        Map<String, String> options = this.getLoginOptions();
        if (!GenericUtils.isEmpty(options)) {
            int index = 0;
            for (Map.Entry<String, String> oe : options.entrySet()) {
                String key = oe.getKey();
                String value = oe.getValue();
                if (index > 0) {
                    sb.append(',');
                }
                sb.append(key);
                if (!Boolean.TRUE.toString().equals(value)) {
                    sb.append('=').append(value);
                }
                ++index;
            }
            if (index > 0) {
                sb.append(' ');
            }
        }
        PublicKey key = super.appendPublicKey(sb, fallbackResolver);
        String kc = this.getComment();
        if (!GenericUtils.isEmpty(kc)) {
            sb.append(' ').append(kc);
        }
        return key;
    }

    @Override
    public String toString() {
        String entry = super.toString();
        String kc = this.getComment();
        Map<String, String> ko = this.getLoginOptions();
        return (GenericUtils.isEmpty(ko) ? "" : ko.toString() + " ") + entry + (GenericUtils.isEmpty(kc) ? "" : " " + kc);
    }

    public static PublickeyAuthenticator fromAuthorizedEntries(PublicKeyEntryResolver fallbackResolver, Collection<? extends AuthorizedKeyEntry> entries) throws IOException, GeneralSecurityException {
        List<PublicKey> keys = AuthorizedKeyEntry.resolveAuthorizedKeys(fallbackResolver, entries);
        if (GenericUtils.isEmpty(keys)) {
            return RejectAllPublickeyAuthenticator.INSTANCE;
        }
        return new KeySetPublickeyAuthenticator(keys);
    }

    public static List<PublicKey> resolveAuthorizedKeys(PublicKeyEntryResolver fallbackResolver, Collection<? extends AuthorizedKeyEntry> entries) throws IOException, GeneralSecurityException {
        if (GenericUtils.isEmpty(entries)) {
            return Collections.emptyList();
        }
        ArrayList<PublicKey> keys = new ArrayList<PublicKey>(entries.size());
        for (AuthorizedKeyEntry authorizedKeyEntry : entries) {
            PublicKey k = authorizedKeyEntry.resolvePublicKey(fallbackResolver);
            if (k == null) continue;
            keys.add(k);
        }
        return keys;
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            List<AuthorizedKeyEntry> list = AuthorizedKeyEntry.readAuthorizedKeys(in, true);
            return list;
        }
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            List<AuthorizedKeyEntry> list = AuthorizedKeyEntry.readAuthorizedKeys(in, true);
            return list;
        }
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(Path path, OpenOption ... options) throws IOException {
        try (InputStream in = Files.newInputStream(path, options);){
            List<AuthorizedKeyEntry> list = AuthorizedKeyEntry.readAuthorizedKeys(in, true);
            return list;
        }
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(String filePath) throws IOException {
        try (FileInputStream in = new FileInputStream(filePath);){
            List<AuthorizedKeyEntry> list = AuthorizedKeyEntry.readAuthorizedKeys(in, true);
            return list;
        }
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(InputStream in, boolean okToClose) throws IOException {
        try (InputStreamReader rdr = new InputStreamReader(NoCloseInputStream.resolveInputStream(in, okToClose), StandardCharsets.UTF_8);){
            List<AuthorizedKeyEntry> list = AuthorizedKeyEntry.readAuthorizedKeys(rdr, true);
            return list;
        }
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(Reader rdr, boolean okToClose) throws IOException {
        try (BufferedReader buf = new BufferedReader(NoCloseReader.resolveReader(rdr, okToClose));){
            List<AuthorizedKeyEntry> list = AuthorizedKeyEntry.readAuthorizedKeys(buf);
            return list;
        }
    }

    public static List<AuthorizedKeyEntry> readAuthorizedKeys(BufferedReader rdr) throws IOException {
        ArrayList<AuthorizedKeyEntry> entries = null;
        String line = rdr.readLine();
        while (line != null) {
            block6: {
                AuthorizedKeyEntry entry;
                block5: {
                    try {
                        entry = AuthorizedKeyEntry.parseAuthorizedKeyEntry(line.trim());
                        if (entry != null) break block5;
                        break block6;
                    }
                    catch (Error | RuntimeException e) {
                        throw new StreamCorruptedException("Failed (" + e.getClass().getSimpleName() + ")" + " to parse key entry=" + line + ": " + e.getMessage());
                    }
                }
                if (entries == null) {
                    entries = new ArrayList<AuthorizedKeyEntry>();
                }
                entries.add(entry);
            }
            line = rdr.readLine();
        }
        if (entries == null) {
            return Collections.emptyList();
        }
        return entries;
    }

    public static AuthorizedKeyEntry parseAuthorizedKeyEntry(String line) throws IllegalArgumentException {
        AuthorizedKeyEntry entry;
        String keyType;
        PublicKeyEntryDecoder<?, ?> decoder;
        if (GenericUtils.isEmpty(line) || line.charAt(0) == '#') {
            return null;
        }
        int startPos = line.indexOf(32);
        if (startPos <= 0) {
            throw new IllegalArgumentException("Bad format (no key data delimiter): " + line);
        }
        int endPos = line.indexOf(32, startPos + 1);
        if (endPos <= startPos) {
            endPos = line.length();
        }
        if ((decoder = KeyUtils.getPublicKeyEntryDecoder(keyType = line.substring(0, startPos))) == null) {
            entry = AuthorizedKeyEntry.parseAuthorizedKeyEntry(line.substring(startPos + 1).trim());
            if (entry == null) {
                throw new IllegalArgumentException("Bad format (no key data after login options): " + line);
            }
            entry.setLoginOptions(AuthorizedKeyEntry.parseLoginOptions(keyType));
        } else {
            String encData = endPos < line.length() - 1 ? line.substring(0, endPos).trim() : line;
            String comment = endPos < line.length() - 1 ? line.substring(endPos + 1).trim() : null;
            entry = AuthorizedKeyEntry.parsePublicKeyEntry(new AuthorizedKeyEntry(), encData);
            entry.setComment(comment);
        }
        return entry;
    }

    public static Map<String, String> parseLoginOptions(String options) {
        String[] pairs = GenericUtils.split(options, ',');
        if (GenericUtils.isEmpty(pairs)) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> optsMap = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        for (String p : pairs) {
            String prev;
            if (GenericUtils.isEmpty(p = GenericUtils.trimToEmpty(p))) continue;
            int pos = p.indexOf(61);
            String name = pos < 0 ? p : GenericUtils.trimToEmpty(p.substring(0, pos));
            CharSequence value = pos < 0 ? null : GenericUtils.trimToEmpty(p.substring(pos + 1));
            if ((value = GenericUtils.stripQuotes(value)) == null) {
                value = Boolean.TRUE.toString();
            }
            if ((prev = optsMap.put(name, value.toString())) == null) continue;
            throw new IllegalArgumentException("Multiple values for key=" + name + ": old=" + prev + ", new=" + value);
        }
        return optsMap;
    }
}

