/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.buffers;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import javax.annotation.concurrent.NotThreadSafe;
import org.parboiled.buffers.InputBuffer;
import org.parboiled.common.IntArrayStack;
import org.parboiled.errors.ParserRuntimeException;
import org.parboiled.support.IndexRange;
import org.parboiled.support.Position;

@Deprecated
@NotThreadSafe
public final class DefaultInputBuffer
implements InputBuffer {
    private final int length;
    private final char[] buffer;
    private int[] newlines;

    public DefaultInputBuffer(char[] buffer) {
        this.buffer = Preconditions.checkNotNull(buffer);
        this.length = buffer.length;
    }

    @Override
    public char charAt(int index) {
        return 0 <= index && index < this.length ? this.buffer[index] : (index - this.length > 100000 ? (char)this.throwParsingException() : (char)'\uffff');
    }

    private char throwParsingException() {
        throw new ParserRuntimeException("Parser read more than 100K chars beyond EOI, verify that your grammar does not consume EOI indefinitely!");
    }

    @Override
    public boolean test(int index, char[] characters) {
        int len = characters.length;
        if (index < 0 || index > this.length - len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.buffer[index + i] == characters[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public String extract(int start, int end) {
        if (start < 0) {
            start = 0;
        }
        if (end >= this.length) {
            end = this.length;
        }
        if (end <= start) {
            return "";
        }
        return new String(this.buffer, start, end - start);
    }

    @Override
    public String extract(IndexRange range) {
        return new String(this.buffer, range.start, Math.min(range.end, this.length) - range.start);
    }

    @Override
    public Position getPosition(int index) {
        this.buildNewlines();
        int line = DefaultInputBuffer.getLine0(this.newlines, index);
        int column = index - (line > 0 ? this.newlines[line - 1] : -1);
        return new Position(line + 1, column);
    }

    @Override
    public int getOriginalIndex(int index) {
        return index;
    }

    private static int getLine0(int[] newlines, int index) {
        int j = Arrays.binarySearch(newlines, index);
        return j >= 0 ? j : -(j + 1);
    }

    @Override
    public String extractLine(int lineNumber) {
        int end;
        this.buildNewlines();
        Preconditions.checkArgument(0 < lineNumber && lineNumber <= this.newlines.length + 1);
        int start = lineNumber > 1 ? this.newlines[lineNumber - 2] + 1 : 0;
        int n = end = lineNumber <= this.newlines.length ? this.newlines[lineNumber - 1] : this.length;
        if (this.charAt(end - 1) == '\r') {
            --end;
        }
        return this.extract(start, end);
    }

    @Override
    public int getLineCount() {
        this.buildNewlines();
        return this.newlines.length + 1;
    }

    private void buildNewlines() {
        if (this.newlines != null) {
            return;
        }
        IntArrayStack stack = new IntArrayStack();
        for (int i = 0; i < this.length; ++i) {
            if (this.buffer[i] != '\n') continue;
            stack.push(i);
        }
        this.newlines = new int[stack.size()];
        stack.getElements(this.newlines, 0);
    }
}

