/*
 * Decompiled with CFR 0.152.
 */
package org.parboiled.transform;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import me.qmx.jitescript.util.CodegenUtils;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.parboiled.transform.InstructionGraphNode;
import org.parboiled.transform.InstructionGroup;
import org.parboiled.transform.ParserClassNode;
import org.parboiled.transform.RuleMethod;
import org.parboiled.transform.Types;
import org.parboiled.transform.process.GroupClassGenerator;

public class VarInitClassGenerator
extends GroupClassGenerator {
    public VarInitClassGenerator(boolean forceCodeBuilding) {
        super(forceCodeBuilding);
    }

    @Override
    public boolean appliesTo(@Nonnull ParserClassNode classNode, @Nonnull RuleMethod method) {
        Preconditions.checkNotNull(method, "method");
        return method.containsVars();
    }

    @Override
    protected boolean appliesTo(InstructionGraphNode group) {
        return group.isVarInitRoot();
    }

    @Override
    protected Type getBaseType() {
        return Types.BASE_VAR_INIT;
    }

    @Override
    protected void generateMethod(InstructionGroup group, ClassWriter cw) {
        MethodVisitor mv = cw.visitMethod(1, "create", CodegenUtils.sig(Object.class, new Class[0]), null, null);
        VarInitClassGenerator.convertXLoads(group);
        group.getInstructions().accept(mv);
        mv.visitInsn(176);
        mv.visitMaxs(0, 0);
    }
}

