/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.audit;

import com.google.gerrit.audit.AuditEvent;
import com.google.gerrit.audit.AuditListener;
import com.google.gerrit.audit.GroupMemberAuditListener;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.client.AccountGroupMember;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AuditService {
    private static final Logger log = LoggerFactory.getLogger(AuditService.class);
    private final DynamicSet<AuditListener> auditListeners;
    private final DynamicSet<GroupMemberAuditListener> groupMemberAuditListeners;

    @Inject
    public AuditService(DynamicSet<AuditListener> auditListeners, DynamicSet<GroupMemberAuditListener> groupMemberAuditListeners) {
        this.auditListeners = auditListeners;
        this.groupMemberAuditListeners = groupMemberAuditListeners;
    }

    public void dispatch(AuditEvent action) {
        for (AuditListener auditListener : this.auditListeners) {
            auditListener.onAuditableAction(action);
        }
    }

    public void dispatchAddAccountsToGroup(Account.Id actor, Collection<AccountGroupMember> added) {
        for (GroupMemberAuditListener auditListener : this.groupMemberAuditListeners) {
            try {
                auditListener.onAddAccountsToGroup(actor, added);
            }
            catch (RuntimeException e) {
                log.error("failed to log add accounts to group event", e);
            }
        }
    }

    public void dispatchDeleteAccountsFromGroup(Account.Id actor, Collection<AccountGroupMember> removed) {
        for (GroupMemberAuditListener auditListener : this.groupMemberAuditListeners) {
            try {
                auditListener.onDeleteAccountsFromGroup(actor, removed);
            }
            catch (RuntimeException e) {
                log.error("failed to log delete accounts from group event", e);
            }
        }
    }

    public void dispatchAddGroupsToGroup(Account.Id actor, Collection<AccountGroupById> added) {
        for (GroupMemberAuditListener auditListener : this.groupMemberAuditListeners) {
            try {
                auditListener.onAddGroupsToGroup(actor, added);
            }
            catch (RuntimeException e) {
                log.error("failed to log add groups to group event", e);
            }
        }
    }

    public void dispatchDeleteGroupsFromGroup(Account.Id actor, Collection<AccountGroupById> removed) {
        for (GroupMemberAuditListener auditListener : this.groupMemberAuditListeners) {
            try {
                auditListener.onDeleteGroupsFromGroup(actor, removed);
            }
            catch (RuntimeException e) {
                log.error("failed to log delete groups from group event", e);
            }
        }
    }
}

