/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.common.data;

import com.google.gerrit.common.data.GroupReference;

public class PermissionRule
implements Comparable<PermissionRule> {
    public static final String FORCE_PUSH = "Force Push";
    public static final String FORCE_EDIT = "Force Edit";
    protected Action action = Action.ALLOW;
    protected boolean force;
    protected int min;
    protected int max;
    protected GroupReference group;

    public PermissionRule() {
    }

    public PermissionRule(GroupReference group) {
        this.group = group;
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action action) {
        if (action == null) {
            throw new NullPointerException("action");
        }
        this.action = action;
    }

    public boolean isDeny() {
        return this.action == Action.DENY;
    }

    public void setDeny() {
        this.action = Action.DENY;
    }

    public boolean isBlock() {
        return this.action == Action.BLOCK;
    }

    public void setBlock() {
        this.action = Action.BLOCK;
    }

    public Boolean getForce() {
        return this.force;
    }

    public void setForce(Boolean newForce) {
        this.force = newForce;
    }

    public Integer getMin() {
        return this.min;
    }

    public void setMin(Integer min) {
        this.min = min;
    }

    public void setMax(Integer max) {
        this.max = max;
    }

    public Integer getMax() {
        return this.max;
    }

    public void setRange(int newMin, int newMax) {
        if (newMax < newMin) {
            this.min = newMax;
            this.max = newMin;
        } else {
            this.min = newMin;
            this.max = newMax;
        }
    }

    public GroupReference getGroup() {
        return this.group;
    }

    public void setGroup(GroupReference newGroup) {
        this.group = newGroup;
    }

    void mergeFrom(PermissionRule src) {
        if (this.getAction() != src.getAction()) {
            if (this.getAction() == Action.BLOCK || src.getAction() == Action.BLOCK) {
                this.setAction(Action.BLOCK);
            } else if (this.getAction() == Action.DENY || src.getAction() == Action.DENY) {
                this.setAction(Action.DENY);
            } else if (this.getAction() == Action.BATCH || src.getAction() == Action.BATCH) {
                this.setAction(Action.BATCH);
            }
        }
        this.setForce(this.getForce() != false || src.getForce() != false);
        this.setRange(Math.min(this.getMin(), src.getMin()), Math.max(this.getMax(), src.getMax()));
    }

    @Override
    public int compareTo(PermissionRule o) {
        int cmp = PermissionRule.action(this) - PermissionRule.action(o);
        if (cmp == 0) {
            cmp = PermissionRule.range(o) - PermissionRule.range(this);
        }
        if (cmp == 0) {
            cmp = PermissionRule.group(this).compareTo(PermissionRule.group(o));
        }
        return cmp;
    }

    private static int action(PermissionRule a) {
        switch (a.getAction()) {
            case DENY: {
                return 0;
            }
        }
        return 1 + a.getAction().ordinal();
    }

    private static int range(PermissionRule a) {
        return Math.abs(a.getMin()) + Math.abs(a.getMax());
    }

    private static String group(PermissionRule a) {
        return a.getGroup().getName() != null ? a.getGroup().getName() : "";
    }

    public String toString() {
        return this.asString(true);
    }

    public String asString(boolean canUseRange) {
        StringBuilder r = new StringBuilder();
        switch (this.getAction()) {
            case ALLOW: {
                break;
            }
            case DENY: {
                r.append("deny ");
                break;
            }
            case BLOCK: {
                r.append("block ");
                break;
            }
            case INTERACTIVE: {
                r.append("interactive ");
                break;
            }
            case BATCH: {
                r.append("batch ");
            }
        }
        if (this.getForce().booleanValue()) {
            r.append("+force ");
        }
        if (canUseRange && (this.getMin() != 0 || this.getMax() != 0)) {
            if (0 <= this.getMin()) {
                r.append('+');
            }
            r.append(this.getMin());
            r.append("..");
            if (0 <= this.getMax()) {
                r.append('+');
            }
            r.append(this.getMax());
            r.append(' ');
        }
        r.append(this.getGroup().toConfigValue());
        return r.toString();
    }

    public static PermissionRule fromString(String src, boolean mightUseRange) {
        String groupName;
        String orig = src;
        PermissionRule rule = new PermissionRule();
        if ((src = src.trim()).startsWith("deny ")) {
            rule.setAction(Action.DENY);
            src = src.substring("deny ".length()).trim();
        } else if (src.startsWith("block ")) {
            rule.setAction(Action.BLOCK);
            src = src.substring("block ".length()).trim();
        } else if (src.startsWith("interactive ")) {
            rule.setAction(Action.INTERACTIVE);
            src = src.substring("interactive ".length()).trim();
        } else if (src.startsWith("batch ")) {
            rule.setAction(Action.BATCH);
            src = src.substring("batch ".length()).trim();
        }
        if (src.startsWith("+force ")) {
            rule.setForce(true);
            src = src.substring("+force ".length()).trim();
        }
        if (mightUseRange && !GroupReference.isGroupReference(src)) {
            int sp = src.indexOf(32);
            String range = src.substring(0, sp);
            if (!range.matches("^([+-]?\\d+)\\.\\.([+-]?\\d+)$")) {
                throw new IllegalArgumentException("Invalid range in rule: " + orig);
            }
            int dotdot = range.indexOf("..");
            int min = PermissionRule.parseInt(range.substring(0, dotdot));
            int max = PermissionRule.parseInt(range.substring(dotdot + 2));
            rule.setRange(min, max);
            src = src.substring(sp + 1).trim();
        }
        if ((groupName = GroupReference.extractGroupName(src)) == null) {
            throw new IllegalArgumentException("Rule must include group: " + orig);
        }
        GroupReference group = new GroupReference();
        group.setName(groupName);
        rule.setGroup(group);
        return rule;
    }

    public boolean hasRange() {
        return this.getMin() != null && this.getMin() != 0 || this.getMax() != null && this.getMax() != 0;
    }

    public static int parseInt(String value) {
        if (value.startsWith("+")) {
            value = value.substring(1);
        }
        return Integer.parseInt(value);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PermissionRule)) {
            return false;
        }
        PermissionRule other = (PermissionRule)obj;
        return this.action.equals((Object)other.action) && this.force == other.force && this.min == other.min && this.max == other.max && this.group.equals(other.group);
    }

    public int hashCode() {
        return this.group.hashCode();
    }

    public static enum Action {
        ALLOW,
        DENY,
        BLOCK,
        INTERACTIVE,
        BATCH;

    }
}

