/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.raw;

import com.google.common.base.Strings;
import com.google.common.io.Resources;
import com.google.gerrit.common.Nullable;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyMapData;
import com.google.template.soy.data.UnsafeSanitizedContentOrdainer;
import com.google.template.soy.tofu.SoyTofu;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class IndexServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private final byte[] indexSource;

    IndexServlet(String canonicalURL, @Nullable String cdnPath) throws URISyntaxException {
        String resourcePath = "com/google/gerrit/httpd/raw/PolyGerritIndexHtml.soy";
        SoyFileSet.Builder builder = SoyFileSet.builder();
        builder.add(Resources.getResource(resourcePath));
        SoyTofu.Renderer renderer = builder.build().compileToTofu().newRenderer("com.google.gerrit.httpd.raw.Index").setContentKind(SanitizedContent.ContentKind.HTML).setData(IndexServlet.getTemplateData(canonicalURL, cdnPath));
        this.indexSource = renderer.render().getBytes(StandardCharsets.UTF_8);
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse rsp) throws IOException {
        rsp.setCharacterEncoding(StandardCharsets.UTF_8.name());
        rsp.setContentType("text/html");
        rsp.setStatus(200);
        try (ServletOutputStream w = rsp.getOutputStream();){
            w.write(this.indexSource);
        }
    }

    static String computeCanonicalPath(String canonicalURL) throws URISyntaxException {
        if (Strings.isNullOrEmpty(canonicalURL)) {
            return "";
        }
        URI uri = new URI(canonicalURL);
        return uri.getPath().replaceAll("/$", "");
    }

    static SoyMapData getTemplateData(String canonicalURL, String cdnPath) throws URISyntaxException {
        String canonicalPath = IndexServlet.computeCanonicalPath(canonicalURL);
        String staticPath = "";
        if (cdnPath != null) {
            staticPath = cdnPath;
        } else if (canonicalPath != null) {
            staticPath = canonicalPath;
        }
        SanitizedContent sanitizedStaticPath = UnsafeSanitizedContentOrdainer.ordainAsSafe(staticPath, SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
        return new SoyMapData("canonicalPath", canonicalPath, "staticResourcePath", sanitizedStaticPath);
    }
}

