/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.project;

import com.google.common.collect.Maps;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupInfo;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.data.ProjectAccess;
import com.google.gerrit.common.data.RefConfigSection;
import com.google.gerrit.common.data.WebLinkInfoCommon;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.httpd.rpc.Handler;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.WebLinks;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.RefControl;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;

class ProjectAccessFactory
extends Handler<ProjectAccess> {
    private final GroupBackend groupBackend;
    private final ProjectCache projectCache;
    private final ProjectControl.Factory projectControlFactory;
    private final GroupControl.Factory groupControlFactory;
    private final MetaDataUpdate.Server metaDataUpdateFactory;
    private final AllProjectsName allProjectsName;
    private final Project.NameKey projectName;
    private ProjectControl pc;
    private WebLinks webLinks;

    @Inject
    ProjectAccessFactory(GroupBackend groupBackend, ProjectCache projectCache, ProjectControl.Factory projectControlFactory, GroupControl.Factory groupControlFactory, MetaDataUpdate.Server metaDataUpdateFactory, AllProjectsName allProjectsName, WebLinks webLinks, @Assisted Project.NameKey name) {
        this.groupBackend = groupBackend;
        this.projectCache = projectCache;
        this.projectControlFactory = projectControlFactory;
        this.groupControlFactory = groupControlFactory;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.allProjectsName = allProjectsName;
        this.webLinks = webLinks;
        this.projectName = name;
    }

    @Override
    public ProjectAccess call() throws NoSuchProjectException, IOException, ConfigInvalidException {
        ProjectConfig config;
        this.pc = this.open();
        try (MetaDataUpdate md = this.metaDataUpdateFactory.create(this.projectName);){
            config = ProjectConfig.read(md);
            if (config.updateGroupNames(this.groupBackend)) {
                md.setMessage("Update group names\n");
                config.commit(md);
                this.projectCache.evict(config.getProject());
                this.pc = this.open();
            } else if (config.getRevision() != null && !config.getRevision().equals(this.pc.getProjectState().getConfig().getRevision())) {
                this.projectCache.evict(config.getProject());
                this.pc = this.open();
            }
        }
        RefControl metaConfigControl = this.pc.controlForRef("refs/meta/config");
        ArrayList<AccessSection> local = new ArrayList<AccessSection>();
        HashSet<String> ownerOf = new HashSet<String>();
        HashMap<AccountGroup.UUID, Boolean> visibleGroups = new HashMap<AccountGroup.UUID, Boolean>();
        for (AccessSection section : config.getAccessSections()) {
            String name = section.getName();
            if ("GLOBAL_CAPABILITIES".equals(name)) {
                if (this.pc.isOwner()) {
                    local.add(section);
                    ownerOf.add(name);
                    continue;
                }
                if (!metaConfigControl.isVisible()) continue;
                local.add(section);
                continue;
            }
            if (!RefConfigSection.isValid(name)) continue;
            RefControl rc = this.pc.controlForRef(name);
            if (rc.isOwner()) {
                local.add(section);
                ownerOf.add(name);
                continue;
            }
            if (metaConfigControl.isVisible()) {
                local.add(section);
                continue;
            }
            if (!rc.isVisible()) continue;
            AccessSection dst = null;
            for (Permission srcPerm : section.getPermissions()) {
                Permission dstPerm = null;
                for (PermissionRule srcRule : srcPerm.getRules()) {
                    AccountGroup.UUID group = srcRule.getGroup().getUUID();
                    if (group == null) continue;
                    Boolean canSeeGroup = (Boolean)visibleGroups.get(group);
                    if (canSeeGroup == null) {
                        try {
                            canSeeGroup = this.groupControlFactory.controlFor(group).isVisible();
                        }
                        catch (NoSuchGroupException e) {
                            canSeeGroup = Boolean.FALSE;
                        }
                        visibleGroups.put(group, canSeeGroup);
                    }
                    if (!canSeeGroup.booleanValue()) continue;
                    if (dstPerm == null) {
                        if (dst == null) {
                            dst = new AccessSection(name);
                            local.add(dst);
                        }
                        dstPerm = dst.getPermission(srcPerm.getName(), true);
                    }
                    dstPerm.add(srcRule);
                }
            }
        }
        if (ownerOf.isEmpty() && this.pc.isOwnerAnyRef()) {
            ownerOf.add("refs/*");
        }
        ProjectAccess detail = new ProjectAccess();
        detail.setProjectName(this.projectName);
        if (config.getRevision() != null) {
            detail.setRevision(config.getRevision().name());
        }
        detail.setInheritsFrom(config.getProject().getParent(this.allProjectsName));
        if (this.projectName.equals(this.allProjectsName) && this.pc.isOwner()) {
            ownerOf.add("GLOBAL_CAPABILITIES");
        }
        detail.setLocal(local);
        detail.setOwnerOf(ownerOf);
        detail.setCanUpload(metaConfigControl.isVisible() && (this.pc.isOwner() || metaConfigControl.canUpload()));
        detail.setConfigVisible(this.pc.isOwner() || metaConfigControl.isVisible());
        detail.setGroupInfo(this.buildGroupInfo(local));
        detail.setLabelTypes(this.pc.getLabelTypes());
        detail.setFileHistoryLinks(this.getConfigFileLogLinks(this.projectName.get()));
        return detail;
    }

    private List<WebLinkInfoCommon> getConfigFileLogLinks(String projectName) {
        List<WebLinkInfoCommon> links = this.webLinks.getFileHistoryLinks(projectName, "refs/meta/config", "project.config");
        return links.isEmpty() ? null : links;
    }

    private Map<AccountGroup.UUID, GroupInfo> buildGroupInfo(List<AccessSection> local) {
        HashMap<AccountGroup.UUID, GroupInfo> infos = new HashMap<AccountGroup.UUID, GroupInfo>();
        for (AccessSection section : local) {
            for (Permission permission : section.getPermissions()) {
                for (PermissionRule rule : permission.getRules()) {
                    AccountGroup.UUID uuid;
                    if (rule.getGroup() == null || (uuid = rule.getGroup().getUUID()) == null || infos.containsKey(uuid)) continue;
                    GroupDescription.Basic group = this.groupBackend.get(uuid);
                    infos.put(uuid, group != null ? new GroupInfo(group) : null);
                }
            }
        }
        return Maps.filterEntries(infos, in -> in.getValue() != null);
    }

    private ProjectControl open() throws NoSuchProjectException {
        return this.projectControlFactory.validateFor(this.projectName, 3);
    }

    static interface Factory {
        public ProjectAccessFactory create(@Assisted Project.NameKey var1);
    }
}

