/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.httpd.rpc.project;

import com.google.common.base.MoreObjects;
import com.google.gerrit.common.ProjectAccessUtil;
import com.google.gerrit.common.data.AccessSection;
import com.google.gerrit.common.data.Capable;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.data.Permission;
import com.google.gerrit.common.data.PermissionRule;
import com.google.gerrit.common.errors.InvalidNameException;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.common.errors.PermissionDeniedException;
import com.google.gerrit.common.errors.UpdateParentFailedException;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.httpd.rpc.Handler;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.config.AllProjectsName;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.gerrit.server.git.ProjectConfig;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.RefPattern;
import com.google.gerrit.server.project.SetParent;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Provider;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;

public abstract class ProjectAccessHandler<T>
extends Handler<T> {
    private final ProjectControl.Factory projectControlFactory;
    protected final GroupBackend groupBackend;
    private final MetaDataUpdate.User metaDataUpdateFactory;
    private final AllProjectsName allProjects;
    private final Provider<SetParent> setParent;
    protected final Project.NameKey projectName;
    protected final ObjectId base;
    private List<AccessSection> sectionList;
    private final Project.NameKey parentProjectName;
    protected String message;
    private boolean checkIfOwner;

    protected ProjectAccessHandler(ProjectControl.Factory projectControlFactory, GroupBackend groupBackend, MetaDataUpdate.User metaDataUpdateFactory, AllProjectsName allProjects, Provider<SetParent> setParent, Project.NameKey projectName, ObjectId base, List<AccessSection> sectionList, Project.NameKey parentProjectName, String message, boolean checkIfOwner) {
        this.projectControlFactory = projectControlFactory;
        this.groupBackend = groupBackend;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.allProjects = allProjects;
        this.setParent = setParent;
        this.projectName = projectName;
        this.base = base;
        this.sectionList = sectionList;
        this.parentProjectName = parentProjectName;
        this.message = message;
        this.checkIfOwner = checkIfOwner;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final T call() throws NoSuchProjectException, IOException, ConfigInvalidException, InvalidNameException, NoSuchGroupException, OrmException, UpdateParentFailedException, PermissionDeniedException {
        ProjectControl projectControl = this.projectControlFactory.controlFor(this.projectName);
        Capable r = projectControl.canPushToAtLeastOneRef();
        if (r != Capable.OK) {
            throw new PermissionDeniedException(r.getMessage());
        }
        try (MetaDataUpdate md = this.metaDataUpdateFactory.create(this.projectName);){
            ProjectConfig config = ProjectConfig.read(md, this.base);
            Set<String> toDelete = ProjectAccessHandler.scanSectionNames(config);
            for (AccessSection section : ProjectAccessUtil.mergeSections(this.sectionList)) {
                String name = section.getName();
                if ("GLOBAL_CAPABILITIES".equals(name)) {
                    if (this.checkIfOwner && !projectControl.isOwner()) continue;
                    this.replace(config, toDelete, section);
                    continue;
                }
                if (!AccessSection.isValid(name) || this.checkIfOwner && !projectControl.controlForRef(name).isOwner()) continue;
                RefPattern.validate(name);
                this.replace(config, toDelete, section);
            }
            for (String name : toDelete) {
                if ("GLOBAL_CAPABILITIES".equals(name)) {
                    if (this.checkIfOwner && !projectControl.isOwner()) continue;
                    config.remove(config.getAccessSection(name));
                    continue;
                }
                if (this.checkIfOwner && !projectControl.controlForRef(name).isOwner()) continue;
                config.remove(config.getAccessSection(name));
            }
            boolean parentProjectUpdate = false;
            if (!config.getProject().getNameKey().equals(this.allProjects) && !config.getProject().getParent(this.allProjects).equals(this.parentProjectName)) {
                parentProjectUpdate = true;
                try {
                    this.setParent.get().validateParentUpdate(projectControl, ((Project.NameKey)MoreObjects.firstNonNull(this.parentProjectName, this.allProjects)).get(), this.checkIfOwner);
                }
                catch (AuthException e) {
                    throw new UpdateParentFailedException("You are not allowed to change the parent project since you are not an administrator. You may save the modifications for review so that an administrator can approve them.", e);
                }
                catch (ResourceConflictException | UnprocessableEntityException e) {
                    throw new UpdateParentFailedException(e.getMessage(), e);
                }
                config.getProject().setParentName(this.parentProjectName);
            }
            if (this.message != null && !this.message.isEmpty()) {
                if (!this.message.endsWith("\n")) {
                    this.message = this.message + "\n";
                }
                md.setMessage(this.message);
            } else {
                md.setMessage("Modify access rules\n");
            }
            T t = this.updateProjectConfig(projectControl, config, md, parentProjectUpdate);
            return t;
        }
        catch (RepositoryNotFoundException notFound) {
            throw new NoSuchProjectException(this.projectName);
        }
    }

    protected abstract T updateProjectConfig(ProjectControl var1, ProjectConfig var2, MetaDataUpdate var3, boolean var4) throws IOException, NoSuchProjectException, ConfigInvalidException, OrmException, PermissionDeniedException;

    private void replace(ProjectConfig config, Set<String> toDelete, AccessSection section) throws NoSuchGroupException {
        for (Permission permission : section.getPermissions()) {
            for (PermissionRule rule : permission.getRules()) {
                this.lookupGroup(rule);
            }
        }
        config.replace(section);
        toDelete.remove(section.getName());
    }

    private static Set<String> scanSectionNames(ProjectConfig config) {
        HashSet<String> names = new HashSet<String>();
        for (AccessSection section : config.getAccessSections()) {
            names.add(section.getName());
        }
        return names;
    }

    private void lookupGroup(PermissionRule rule) throws NoSuchGroupException {
        GroupReference ref = rule.getGroup();
        if (ref.getUUID() == null) {
            GroupReference group = GroupBackends.findBestSuggestion(this.groupBackend, ref.getName());
            if (group == null) {
                throw new NoSuchGroupException(ref.getName());
            }
            ref.setUUID(group.getUUID());
        }
    }
}

