/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.lucene;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.gerrit.lucene.AbstractLuceneIndex;
import com.google.gerrit.lucene.ChangeSubIndex;
import com.google.gerrit.lucene.GerritIndexWriterConfig;
import com.google.gerrit.lucene.LuceneIndexModule;
import com.google.gerrit.lucene.LuceneVersionManager;
import com.google.gerrit.lucene.QueryBuilder;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.StarredChangesUtil;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.config.SitePaths;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.index.FieldDef;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.index.IndexUtils;
import com.google.gerrit.server.index.QueryOptions;
import com.google.gerrit.server.index.Schema;
import com.google.gerrit.server.index.change.ChangeField;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.index.change.ChangeIndexRewriter;
import com.google.gerrit.server.project.SubmitRuleOptions;
import com.google.gerrit.server.query.Predicate;
import com.google.gerrit.server.query.QueryParseException;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gerrit.server.query.change.ChangeDataSource;
import com.google.gwtorm.protobuf.ProtobufCodec;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.OrmRuntimeException;
import com.google.gwtorm.server.ResultSet;
import com.google.inject.Provider;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.BytesRef;
import org.eclipse.jgit.lib.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LuceneChangeIndex
implements ChangeIndex {
    private static final Logger log = LoggerFactory.getLogger(LuceneChangeIndex.class);
    static final String UPDATED_SORT_FIELD = AbstractLuceneIndex.sortFieldName(ChangeField.UPDATED);
    static final String ID_SORT_FIELD = AbstractLuceneIndex.sortFieldName(ChangeField.LEGACY_ID);
    private static final String CHANGES_PREFIX = "changes_";
    private static final String CHANGES_OPEN = "open";
    private static final String CHANGES_CLOSED = "closed";
    private static final String ADDED_FIELD = ChangeField.ADDED.getName();
    private static final String APPROVAL_FIELD = ChangeField.APPROVAL.getName();
    private static final String CHANGE_FIELD = ChangeField.CHANGE.getName();
    private static final String DELETED_FIELD = ChangeField.DELETED.getName();
    private static final String MERGEABLE_FIELD = ChangeField.MERGEABLE.getName();
    private static final String PATCH_SET_FIELD = ChangeField.PATCH_SET.getName();
    private static final String REF_STATE_FIELD = ChangeField.REF_STATE.getName();
    private static final String REF_STATE_PATTERN_FIELD = ChangeField.REF_STATE_PATTERN.getName();
    private static final String REVIEWEDBY_FIELD = ChangeField.REVIEWEDBY.getName();
    private static final String REVIEWER_FIELD = ChangeField.REVIEWER.getName();
    private static final String HASHTAG_FIELD = ChangeField.HASHTAG_CASE_AWARE.getName();
    private static final String STAR_FIELD = ChangeField.STAR.getName();
    private static final String SUBMIT_RECORD_LENIENT_FIELD = ChangeField.STORED_SUBMIT_RECORD_LENIENT.getName();
    private static final String SUBMIT_RECORD_STRICT_FIELD = ChangeField.STORED_SUBMIT_RECORD_STRICT.getName();
    private static final String UNRESOLVED_COMMENT_COUNT_FIELD = ChangeField.UNRESOLVED_COMMENT_COUNT.getName();
    private final FieldDef.FillArgs fillArgs;
    private final ListeningExecutorService executor;
    private final Provider<ReviewDb> db;
    private final ChangeData.Factory changeDataFactory;
    private final Schema<ChangeData> schema;
    private final QueryBuilder<ChangeData> queryBuilder;
    private final ChangeSubIndex openIndex;
    private final ChangeSubIndex closedIndex;

    static Term idTerm(ChangeData cd) {
        return QueryBuilder.intTerm(ChangeField.LEGACY_ID.getName(), cd.getId().get());
    }

    static Term idTerm(Change.Id id) {
        return QueryBuilder.intTerm(ChangeField.LEGACY_ID.getName(), id.get());
    }

    @AssistedInject
    LuceneChangeIndex(@GerritServerConfig Config cfg, SitePaths sitePaths, @IndexExecutor(value=QueueProvider.QueueType.INTERACTIVE) ListeningExecutorService executor, Provider<ReviewDb> db, ChangeData.Factory changeDataFactory, FieldDef.FillArgs fillArgs, @Assisted Schema<ChangeData> schema) throws IOException {
        this.fillArgs = fillArgs;
        this.executor = executor;
        this.db = db;
        this.changeDataFactory = changeDataFactory;
        this.schema = schema;
        GerritIndexWriterConfig openConfig = new GerritIndexWriterConfig(cfg, "changes_open");
        GerritIndexWriterConfig closedConfig = new GerritIndexWriterConfig(cfg, "changes_closed");
        this.queryBuilder = new QueryBuilder<ChangeData>(schema, openConfig.getAnalyzer());
        SearcherFactory searcherFactory = new SearcherFactory();
        if (LuceneIndexModule.isInMemoryTest(cfg)) {
            this.openIndex = new ChangeSubIndex(schema, sitePaths, new RAMDirectory(), "ramOpen", openConfig, searcherFactory);
            this.closedIndex = new ChangeSubIndex(schema, sitePaths, new RAMDirectory(), "ramClosed", closedConfig, searcherFactory);
        } else {
            Path dir = LuceneVersionManager.getDir(sitePaths, CHANGES_PREFIX, schema);
            this.openIndex = new ChangeSubIndex(schema, sitePaths, dir.resolve(CHANGES_OPEN), openConfig, searcherFactory);
            this.closedIndex = new ChangeSubIndex(schema, sitePaths, dir.resolve(CHANGES_CLOSED), closedConfig, searcherFactory);
        }
    }

    @Override
    public void close() {
        try {
            this.openIndex.close();
        }
        finally {
            this.closedIndex.close();
        }
    }

    @Override
    public Schema<ChangeData> getSchema() {
        return this.schema;
    }

    @Override
    public void replace(ChangeData cd) throws IOException {
        Term id = LuceneChangeIndex.idTerm(cd);
        Document doc = this.openIndex.toDocument(cd, this.fillArgs);
        try {
            if (cd.change().getStatus().isOpen()) {
                Futures.allAsList(this.closedIndex.delete(id), this.openIndex.replace(id, doc)).get();
            } else {
                Futures.allAsList(this.openIndex.delete(id), this.closedIndex.replace(id, doc)).get();
            }
        }
        catch (OrmException | InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void delete(Change.Id id) throws IOException {
        Term idTerm = LuceneChangeIndex.idTerm(id);
        try {
            Futures.allAsList(this.openIndex.delete(idTerm), this.closedIndex.delete(idTerm)).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void deleteAll() throws IOException {
        this.openIndex.deleteAll();
        this.closedIndex.deleteAll();
    }

    public ChangeDataSource getSource(Predicate<ChangeData> p, QueryOptions opts) throws QueryParseException {
        EnumSet<Change.Status> statuses = ChangeIndexRewriter.getPossibleStatus(p);
        ArrayList<ChangeSubIndex> indexes = new ArrayList<ChangeSubIndex>(2);
        if (!Sets.intersection(statuses, ChangeIndexRewriter.OPEN_STATUSES).isEmpty()) {
            indexes.add(this.openIndex);
        }
        if (!Sets.intersection(statuses, ChangeIndexRewriter.CLOSED_STATUSES).isEmpty()) {
            indexes.add(this.closedIndex);
        }
        return new QuerySource(indexes, p, opts, this.getSort());
    }

    @Override
    public void markReady(boolean ready) throws IOException {
        this.openIndex.markReady(ready);
    }

    private Sort getSort() {
        return new Sort(new SortField(UPDATED_SORT_FIELD, SortField.Type.LONG, true), new SortField(ID_SORT_FIELD, SortField.Type.LONG, true));
    }

    public ChangeSubIndex getClosedChangesIndex() {
        return this.closedIndex;
    }

    private static ListMultimap<String, IndexableField> fields(Document doc, Set<String> fields) {
        Multimap stored = MultimapBuilder.hashKeys(fields.size()).arrayListValues(4).build();
        for (IndexableField f : doc) {
            String name = f.name();
            if (!fields.contains(name)) continue;
            stored.put(name, f);
        }
        return stored;
    }

    private ChangeData toChangeData(ListMultimap<String, IndexableField> doc, Set<String> fields, String idFieldName) {
        ChangeData cd;
        IndexableField cb = Iterables.getFirst(doc.get((Object)CHANGE_FIELD), null);
        if (cb != null) {
            BytesRef proto = cb.binaryValue();
            cd = this.changeDataFactory.create(this.db.get(), ChangeField.CHANGE_CODEC.decode(proto.bytes, proto.offset, proto.length));
        } else {
            IndexableField f = Iterables.getFirst(doc.get((Object)idFieldName), null);
            Change.Id id = new Change.Id(f.numericValue().intValue());
            IndexableField project = Iterables.getFirst(doc.get((Object)ChangeField.PROJECT.getName()), null);
            cd = project == null ? this.changeDataFactory.createOnlyWhenNoteDbDisabled(this.db.get(), id) : this.changeDataFactory.create(this.db.get(), new Project.NameKey(project.stringValue()), id);
        }
        if (fields.contains(PATCH_SET_FIELD)) {
            this.decodePatchSets(doc, cd);
        }
        if (fields.contains(APPROVAL_FIELD)) {
            this.decodeApprovals(doc, cd);
        }
        if (fields.contains(ADDED_FIELD) && fields.contains(DELETED_FIELD)) {
            this.decodeChangedLines(doc, cd);
        }
        if (fields.contains(MERGEABLE_FIELD)) {
            this.decodeMergeable(doc, cd);
        }
        if (fields.contains(REVIEWEDBY_FIELD)) {
            this.decodeReviewedBy(doc, cd);
        }
        if (fields.contains(HASHTAG_FIELD)) {
            this.decodeHashtags(doc, cd);
        }
        if (fields.contains(STAR_FIELD)) {
            this.decodeStar(doc, cd);
        }
        if (fields.contains(REVIEWER_FIELD)) {
            this.decodeReviewers(doc, cd);
        }
        this.decodeSubmitRecords(doc, SUBMIT_RECORD_STRICT_FIELD, ChangeField.SUBMIT_RULE_OPTIONS_STRICT, cd);
        this.decodeSubmitRecords(doc, SUBMIT_RECORD_LENIENT_FIELD, ChangeField.SUBMIT_RULE_OPTIONS_LENIENT, cd);
        if (fields.contains(REF_STATE_FIELD)) {
            this.decodeRefStates(doc, cd);
        }
        if (fields.contains(REF_STATE_PATTERN_FIELD)) {
            this.decodeRefStatePatterns(doc, cd);
        }
        this.decodeUnresolvedCommentCount(doc, cd);
        return cd;
    }

    private void decodePatchSets(ListMultimap<String, IndexableField> doc, ChangeData cd) {
        List<PatchSet> patchSets = LuceneChangeIndex.decodeProtos(doc, PATCH_SET_FIELD, ChangeField.PATCH_SET_CODEC);
        if (!patchSets.isEmpty()) {
            cd.setPatchSets(patchSets);
        }
    }

    private void decodeApprovals(ListMultimap<String, IndexableField> doc, ChangeData cd) {
        cd.setCurrentApprovals(LuceneChangeIndex.decodeProtos(doc, APPROVAL_FIELD, ChangeField.APPROVAL_CODEC));
    }

    private void decodeChangedLines(ListMultimap<String, IndexableField> doc, ChangeData cd) {
        IndexableField added = Iterables.getFirst(doc.get((Object)ADDED_FIELD), null);
        IndexableField deleted = Iterables.getFirst(doc.get((Object)DELETED_FIELD), null);
        if (added != null && deleted != null) {
            cd.setChangedLines(added.numericValue().intValue(), deleted.numericValue().intValue());
        } else {
            cd.setNoChangedLines();
        }
    }

    private void decodeMergeable(ListMultimap<String, IndexableField> doc, ChangeData cd) {
        IndexableField f = Iterables.getFirst(doc.get((Object)MERGEABLE_FIELD), null);
        if (f != null) {
            String mergeable = f.stringValue();
            if ("1".equals(mergeable)) {
                cd.setMergeable(true);
            } else if ("0".equals(mergeable)) {
                cd.setMergeable(false);
            }
        }
    }

    private void decodeReviewedBy(ListMultimap<String, IndexableField> doc, ChangeData cd) {
        Collection reviewedBy = doc.get((Object)REVIEWEDBY_FIELD);
        if (reviewedBy.size() > 0) {
            HashSet<Account.Id> accounts = Sets.newHashSetWithExpectedSize(reviewedBy.size());
            for (IndexableField r : reviewedBy) {
                int id = r.numericValue().intValue();
                if (reviewedBy.size() == 1 && id == ChangeField.NOT_REVIEWED) break;
                accounts.add(new Account.Id(id));
            }
            cd.setReviewedBy(accounts);
        }
    }

    private void decodeHashtags(ListMultimap<String, IndexableField> doc, ChangeData cd) {
        Collection hashtag = doc.get((Object)HASHTAG_FIELD);
        HashSet<String> hashtags = Sets.newHashSetWithExpectedSize(hashtag.size());
        for (IndexableField r : hashtag) {
            hashtags.add(r.binaryValue().utf8ToString());
        }
        cd.setHashtags(hashtags);
    }

    private void decodeStar(ListMultimap<String, IndexableField> doc, ChangeData cd) {
        Collection star = doc.get((Object)STAR_FIELD);
        Multimap stars = MultimapBuilder.hashKeys().arrayListValues().build();
        for (IndexableField r : star) {
            StarredChangesUtil.StarField starField = StarredChangesUtil.StarField.parse(r.stringValue());
            if (starField == null) continue;
            stars.put(starField.accountId(), starField.label());
        }
        cd.setStars((ListMultimap<Account.Id, String>)stars);
    }

    private void decodeReviewers(ListMultimap<String, IndexableField> doc, ChangeData cd) {
        cd.setReviewers(ChangeField.parseReviewerFieldValues(FluentIterable.from(doc.get((Object)REVIEWER_FIELD)).transform(IndexableField::stringValue)));
    }

    private void decodeSubmitRecords(ListMultimap<String, IndexableField> doc, String field, SubmitRuleOptions opts, ChangeData cd) {
        ChangeField.parseSubmitRecords(Collections2.transform(doc.get((Object)field), f -> f.binaryValue().utf8ToString()), opts, cd);
    }

    private void decodeRefStates(ListMultimap<String, IndexableField> doc, ChangeData cd) {
        cd.setRefStates(LuceneChangeIndex.copyAsBytes(doc.get((Object)REF_STATE_FIELD)));
    }

    private void decodeRefStatePatterns(ListMultimap<String, IndexableField> doc, ChangeData cd) {
        cd.setRefStatePatterns(LuceneChangeIndex.copyAsBytes(doc.get((Object)REF_STATE_PATTERN_FIELD)));
    }

    private void decodeUnresolvedCommentCount(ListMultimap<String, IndexableField> doc, ChangeData cd) {
        IndexableField f = Iterables.getFirst(doc.get((Object)UNRESOLVED_COMMENT_COUNT_FIELD), null);
        if (f != null && f.numericValue() != null) {
            cd.setUnresolvedCommentCount(f.numericValue().intValue());
        }
    }

    private static <T> List<T> decodeProtos(ListMultimap<String, IndexableField> doc, String fieldName, ProtobufCodec<T> codec) {
        Collection fields = doc.get((Object)fieldName);
        if (fields.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<T> result = new ArrayList<T>(fields.size());
        for (IndexableField f : fields) {
            BytesRef r = f.binaryValue();
            result.add(codec.decode(r.bytes, r.offset, r.length));
        }
        return result;
    }

    private static List<byte[]> copyAsBytes(Collection<IndexableField> fields) {
        return fields.stream().map(f -> {
            BytesRef ref = f.binaryValue();
            byte[] b = new byte[ref.length];
            System.arraycopy(ref.bytes, ref.offset, b, 0, ref.length);
            return b;
        }).collect(Collectors.toList());
    }

    private class ChangeDataResults
    implements ResultSet<ChangeData> {
        private final Future<List<Document>> future;
        private final Set<String> fields;

        ChangeDataResults(Future<List<Document>> future, Set<String> fields) {
            this.future = future;
            this.fields = fields;
        }

        @Override
        public Iterator<ChangeData> iterator() {
            return this.toList().iterator();
        }

        @Override
        public List<ChangeData> toList() {
            try {
                List<Document> docs = this.future.get();
                ArrayList<ChangeData> result = new ArrayList<ChangeData>(docs.size());
                String idFieldName = ChangeField.LEGACY_ID.getName();
                for (Document doc : docs) {
                    result.add(LuceneChangeIndex.this.toChangeData(LuceneChangeIndex.fields(doc, this.fields), this.fields, idFieldName));
                }
                return result;
            }
            catch (InterruptedException e) {
                this.close();
                throw new OrmRuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwables.throwIfUnchecked(e.getCause());
                throw new OrmRuntimeException(e.getCause());
            }
        }

        @Override
        public void close() {
            this.future.cancel(false);
        }
    }

    private class QuerySource
    implements ChangeDataSource {
        private final List<ChangeSubIndex> indexes;
        private final Predicate<ChangeData> predicate;
        private final Query query;
        private final QueryOptions opts;
        private final Sort sort;

        private QuerySource(List<ChangeSubIndex> indexes, Predicate<ChangeData> predicate, QueryOptions opts, Sort sort) throws QueryParseException {
            this.indexes = indexes;
            this.predicate = predicate;
            this.query = Preconditions.checkNotNull(LuceneChangeIndex.this.queryBuilder.toQuery(predicate), "null query from Lucene");
            this.opts = opts;
            this.sort = sort;
        }

        @Override
        public int getCardinality() {
            return 10;
        }

        @Override
        public boolean hasChange() {
            return false;
        }

        public String toString() {
            return this.predicate.toString();
        }

        @Override
        public ResultSet<ChangeData> read() throws OrmException {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                throw new OrmException("interrupted");
            }
            final Set<String> fields = IndexUtils.changeFields(this.opts);
            return new ChangeDataResults(LuceneChangeIndex.this.executor.submit(new Callable<List<Document>>(){

                @Override
                public List<Document> call() throws IOException {
                    return QuerySource.this.doRead(fields);
                }

                public String toString() {
                    return QuerySource.this.predicate.toString();
                }
            }), fields);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<Document> doRead(Set<String> fields) throws IOException {
            IndexSearcher[] searchers = new IndexSearcher[this.indexes.size()];
            try {
                int realLimit = this.opts.start() + this.opts.limit();
                if (Integer.MAX_VALUE - this.opts.limit() < this.opts.start()) {
                    realLimit = Integer.MAX_VALUE;
                }
                TopFieldDocs[] hits = new TopFieldDocs[this.indexes.size()];
                for (int i = 0; i < this.indexes.size(); ++i) {
                    searchers[i] = this.indexes.get(i).acquire();
                    hits[i] = searchers[i].search(this.query, realLimit, this.sort);
                }
                TopFieldDocs docs = TopDocs.merge(this.sort, realLimit, hits);
                ArrayList<Document> result = new ArrayList<Document>(docs.scoreDocs.length);
                for (int i = this.opts.start(); i < docs.scoreDocs.length; ++i) {
                    ScoreDoc sd = docs.scoreDocs[i];
                    result.add(searchers[sd.shardIndex].doc(sd.doc, fields));
                }
                ArrayList<Document> arrayList = result;
                return arrayList;
            }
            finally {
                for (int i = 0; i < this.indexes.size(); ++i) {
                    if (searchers[i] == null) continue;
                    try {
                        this.indexes.get(i).release(searchers[i]);
                        continue;
                    }
                    catch (IOException e) {
                        log.warn("cannot release Lucene searcher", e);
                    }
                }
            }
        }
    }
}

