/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.reviewdb.client;

import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gwtorm.client.Column;
import com.google.gwtorm.client.StringKey;
import java.sql.Timestamp;
import java.util.Objects;

public final class ChangeMessage {
    @Column(id=1, name="--NONE--")
    protected Key key;
    @Column(id=2, name="author_id", notNull=false)
    protected Account.Id author;
    @Column(id=3)
    protected Timestamp writtenOn;
    @Column(id=4, notNull=false, length=0x7FFFFFFF)
    protected String message;
    @Column(id=5, notNull=false)
    protected PatchSet.Id patchset;
    @Column(id=6, notNull=false)
    protected String tag;
    @Column(id=7, notNull=false)
    protected Account.Id realAuthor;

    protected ChangeMessage() {
    }

    public ChangeMessage(Key k, Account.Id a, Timestamp wo, PatchSet.Id psid) {
        this.key = k;
        this.author = a;
        this.writtenOn = wo;
        this.patchset = psid;
    }

    public Key getKey() {
        return this.key;
    }

    public Account.Id getAuthor() {
        return this.author;
    }

    public void setAuthor(Account.Id accountId) {
        if (this.author != null) {
            throw new IllegalStateException("Cannot modify author once assigned");
        }
        this.author = accountId;
    }

    public Account.Id getRealAuthor() {
        return this.realAuthor != null ? this.realAuthor : this.getAuthor();
    }

    public void setRealAuthor(Account.Id id) {
        this.realAuthor = Objects.equals(this.getAuthor(), id) ? null : id;
    }

    public Timestamp getWrittenOn() {
        return this.writtenOn;
    }

    public void setWrittenOn(Timestamp ts) {
        this.writtenOn = ts;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String s) {
        this.message = s;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public PatchSet.Id getPatchSetId() {
        return this.patchset;
    }

    public void setPatchSetId(PatchSet.Id id) {
        this.patchset = id;
    }

    public String toString() {
        return "ChangeMessage{key=" + this.key + ", author=" + this.author + ", realAuthor=" + this.realAuthor + ", writtenOn=" + this.writtenOn + ", patchset=" + this.patchset + ", tag=" + this.tag + ", message=[" + this.message + "]}";
    }

    public static class Key
    extends StringKey<Change.Id> {
        private static final long serialVersionUID = 1L;
        @Column(id=1)
        protected Change.Id changeId;
        @Column(id=2, length=40)
        protected String uuid;

        protected Key() {
            this.changeId = new Change.Id();
        }

        public Key(Change.Id change, String uuid) {
            this.changeId = change;
            this.uuid = uuid;
        }

        @Override
        public Change.Id getParentKey() {
            return this.changeId;
        }

        @Override
        public String get() {
            return this.uuid;
        }

        @Override
        public void set(String newValue) {
            this.uuid = newValue;
        }
    }
}

