/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ChangeUtil;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.NotesMigration;
import com.google.gerrit.server.notedb.PatchSetState;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Collections;
import java.util.List;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevWalk;

@Singleton
public class PatchSetUtil {
    private final NotesMigration migration;

    @Inject
    PatchSetUtil(NotesMigration migration) {
        this.migration = migration;
    }

    public PatchSet current(ReviewDb db, ChangeNotes notes) throws OrmException {
        return this.get(db, notes, notes.getChange().currentPatchSetId());
    }

    public PatchSet get(ReviewDb db, ChangeNotes notes, PatchSet.Id psId) throws OrmException {
        if (!this.migration.readChanges()) {
            return db.patchSets().get(psId);
        }
        return ((ChangeNotes)notes.load()).getPatchSets().get(psId);
    }

    public ImmutableCollection<PatchSet> byChange(ReviewDb db, ChangeNotes notes) throws OrmException {
        if (!this.migration.readChanges()) {
            return ChangeUtil.PS_ID_ORDER.immutableSortedCopy(db.patchSets().byChange(notes.getChangeId()));
        }
        return ((ChangeNotes)notes.load()).getPatchSets().values();
    }

    public ImmutableMap<PatchSet.Id, PatchSet> byChangeAsMap(ReviewDb db, ChangeNotes notes) throws OrmException {
        if (!this.migration.readChanges()) {
            ImmutableMap.Builder<PatchSet.Id, PatchSet> result = ImmutableMap.builder();
            for (PatchSet ps : ChangeUtil.PS_ID_ORDER.sortedCopy(db.patchSets().byChange(notes.getChangeId()))) {
                result.put(ps.getId(), ps);
            }
            return result.build();
        }
        return ((ChangeNotes)notes.load()).getPatchSets();
    }

    public PatchSet insert(ReviewDb db, RevWalk rw, ChangeUpdate update, PatchSet.Id psId, ObjectId commit, boolean draft, List<String> groups, String pushCertificate, String description) throws OrmException, IOException {
        Preconditions.checkNotNull(groups, "groups may not be null");
        this.ensurePatchSetMatches(psId, update);
        PatchSet ps = new PatchSet(psId);
        ps.setRevision(new RevId(commit.name()));
        ps.setUploader(update.getAccountId());
        ps.setCreatedOn(new Timestamp(update.getWhen().getTime()));
        ps.setDraft(draft);
        ps.setGroups(groups);
        ps.setPushCertificate(pushCertificate);
        ps.setDescription(description);
        db.patchSets().insert(Collections.singleton(ps));
        update.setCommit(rw, commit, pushCertificate);
        update.setPsDescription(description);
        update.setGroups(groups);
        if (draft) {
            update.setPatchSetState(PatchSetState.DRAFT);
        }
        return ps;
    }

    public void publish(ReviewDb db, ChangeUpdate update, PatchSet ps) throws OrmException {
        this.ensurePatchSetMatches(ps.getId(), update);
        ps.setDraft(false);
        update.setPatchSetState(PatchSetState.PUBLISHED);
        db.patchSets().update(Collections.singleton(ps));
    }

    public void delete(ReviewDb db, ChangeUpdate update, PatchSet ps) throws OrmException {
        this.ensurePatchSetMatches(ps.getId(), update);
        Preconditions.checkArgument(ps.isDraft(), "cannot delete non-draft patch set %s", (Object)ps.getId());
        update.setPatchSetState(PatchSetState.DELETED);
        db.patchSets().delete(Collections.singleton(ps));
    }

    private void ensurePatchSetMatches(PatchSet.Id psId, ChangeUpdate update) {
        Change.Id changeId = update.getChange().getId();
        Preconditions.checkArgument(psId.getParentKey().equals(changeId), "cannot modify patch set %s on update for change %s", (Object)psId, (Object)changeId);
        if (update.getPatchSetId() != null) {
            Preconditions.checkArgument(update.getPatchSetId().equals(psId), "cannot modify patch set %s on update for %s", (Object)psId, (Object)update.getPatchSetId());
        } else {
            update.setPatchSetId(psId);
        }
    }

    public void setGroups(ReviewDb db, ChangeUpdate update, PatchSet ps, List<String> groups) throws OrmException {
        ps.setGroups(groups);
        update.setGroups(groups);
        db.patchSets().update(Collections.singleton(ps));
    }
}

