/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.gerrit.common.data.WebLinkInfoCommon;
import com.google.gerrit.extensions.common.DiffWebLinkInfo;
import com.google.gerrit.extensions.common.WebLinkInfo;
import com.google.gerrit.extensions.registration.DynamicSet;
import com.google.gerrit.extensions.webui.BranchWebLink;
import com.google.gerrit.extensions.webui.DiffWebLink;
import com.google.gerrit.extensions.webui.FileHistoryWebLink;
import com.google.gerrit.extensions.webui.FileWebLink;
import com.google.gerrit.extensions.webui.ParentWebLink;
import com.google.gerrit.extensions.webui.PatchSetWebLink;
import com.google.gerrit.extensions.webui.ProjectWebLink;
import com.google.gerrit.extensions.webui.TagWebLink;
import com.google.gerrit.extensions.webui.WebLink;
import com.google.gerrit.reviewdb.client.Patch;
import com.google.gerrit.reviewdb.client.Project;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class WebLinks {
    private static final Logger log = LoggerFactory.getLogger(WebLinks.class);
    private static final Predicate<WebLinkInfo> INVALID_WEBLINK = link -> {
        if (link == null) {
            return false;
        }
        if (Strings.isNullOrEmpty(link.name) || Strings.isNullOrEmpty(link.url)) {
            log.warn("{} is missing name and/or url", (Object)link.getClass().getName());
            return false;
        }
        return true;
    };
    private static final Predicate<WebLinkInfoCommon> INVALID_WEBLINK_COMMON = link -> {
        if (link == null) {
            return false;
        }
        if (Strings.isNullOrEmpty(link.name) || Strings.isNullOrEmpty(link.url)) {
            log.warn("{} is missing name and/or url", (Object)link.getClass().getName());
            return false;
        }
        return true;
    };
    private final DynamicSet<PatchSetWebLink> patchSetLinks;
    private final DynamicSet<ParentWebLink> parentLinks;
    private final DynamicSet<FileWebLink> fileLinks;
    private final DynamicSet<FileHistoryWebLink> fileHistoryLinks;
    private final DynamicSet<DiffWebLink> diffLinks;
    private final DynamicSet<ProjectWebLink> projectLinks;
    private final DynamicSet<BranchWebLink> branchLinks;
    private final DynamicSet<TagWebLink> tagLinks;

    @Inject
    public WebLinks(DynamicSet<PatchSetWebLink> patchSetLinks, DynamicSet<ParentWebLink> parentLinks, DynamicSet<FileWebLink> fileLinks, DynamicSet<FileHistoryWebLink> fileLogLinks, DynamicSet<DiffWebLink> diffLinks, DynamicSet<ProjectWebLink> projectLinks, DynamicSet<BranchWebLink> branchLinks, DynamicSet<TagWebLink> tagLinks) {
        this.patchSetLinks = patchSetLinks;
        this.parentLinks = parentLinks;
        this.fileLinks = fileLinks;
        this.fileHistoryLinks = fileLogLinks;
        this.diffLinks = diffLinks;
        this.projectLinks = projectLinks;
        this.branchLinks = branchLinks;
        this.tagLinks = tagLinks;
    }

    public List<WebLinkInfo> getPatchSetLinks(Project.NameKey project, String commit) {
        return this.filterLinks(this.patchSetLinks, webLink -> webLink.getPatchSetWebLink(project.get(), commit));
    }

    public List<WebLinkInfo> getParentLinks(Project.NameKey project, String revision) {
        return this.filterLinks(this.parentLinks, webLink -> webLink.getParentWebLink(project.get(), revision));
    }

    public List<WebLinkInfo> getFileLinks(String project, String revision, String file) {
        return Patch.isMagic(file) ? Collections.emptyList() : this.filterLinks(this.fileLinks, webLink -> webLink.getFileWebLink(project, revision, file));
    }

    public List<WebLinkInfoCommon> getFileHistoryLinks(String project, String revision, String file) {
        if (Patch.isMagic(file)) {
            return Collections.emptyList();
        }
        return FluentIterable.from(this.fileHistoryLinks).transform(webLink -> {
            WebLinkInfo info = webLink.getFileHistoryWebLink(project, revision, file);
            if (info == null) {
                return null;
            }
            WebLinkInfoCommon commonInfo = new WebLinkInfoCommon();
            commonInfo.name = info.name;
            commonInfo.imageUrl = info.imageUrl;
            commonInfo.url = info.url;
            commonInfo.target = info.target;
            return commonInfo;
        }).filter(INVALID_WEBLINK_COMMON).toList();
    }

    public List<DiffWebLinkInfo> getDiffLinks(String project, int changeId, Integer patchSetIdA, String revisionA, String fileA, int patchSetIdB, String revisionB, String fileB) {
        if (Patch.isMagic(fileA) || Patch.isMagic(fileB)) {
            return Collections.emptyList();
        }
        return FluentIterable.from(this.diffLinks).transform(webLink -> webLink.getDiffLink(project, changeId, patchSetIdA, revisionA, fileA, patchSetIdB, revisionB, fileB)).filter(INVALID_WEBLINK).toList();
    }

    public List<WebLinkInfo> getProjectLinks(String project) {
        return this.filterLinks(this.projectLinks, webLink -> webLink.getProjectWeblink(project));
    }

    public List<WebLinkInfo> getBranchLinks(String project, String branch) {
        return this.filterLinks(this.branchLinks, webLink -> webLink.getBranchWebLink(project, branch));
    }

    public List<WebLinkInfo> getTagLinks(String project, String tag) {
        return this.filterLinks(this.tagLinks, webLink -> webLink.getTagWebLink(project, tag));
    }

    private <T extends WebLink> List<WebLinkInfo> filterLinks(DynamicSet<T> links, Function<T, WebLinkInfo> transformer) {
        return FluentIterable.from(links).transform(transformer).filter(INVALID_WEBLINK).toList();
    }
}

