/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.collect.ImmutableSet;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.ExternalId;
import com.google.gerrit.server.account.ExternalIdsUpdate;
import com.google.gwtorm.server.OrmException;
import java.util.HashSet;
import java.util.Set;

public class ExternalIdsBatchUpdate {
    private final Set<ExternalId> toAdd = new HashSet<ExternalId>();
    private final Set<ExternalId> toDelete = new HashSet<ExternalId>();

    public void replace(ExternalId extIdToDelete, ExternalId extIdToAdd) {
        ExternalIdsUpdate.checkSameAccount(ImmutableSet.of(extIdToDelete, extIdToAdd));
        this.toAdd.add(extIdToAdd);
        this.toDelete.add(extIdToDelete);
    }

    public void commit(ReviewDb db) throws OrmException {
        if (this.toDelete.isEmpty() && this.toAdd.isEmpty()) {
            return;
        }
        db.accountExternalIds().delete(ExternalId.toAccountExternalIds(this.toDelete));
        db.accountExternalIds().insert(ExternalId.toAccountExternalIds(this.toAdd));
        this.toAdd.clear();
        this.toDelete.clear();
    }
}

