/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.gerrit.extensions.client.ProjectWatchInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class GetWatchedProjects
implements RestReadView<AccountResource> {
    private final Provider<IdentifiedUser> self;
    private final WatchConfig.Accessor watchConfig;

    @Inject
    public GetWatchedProjects(Provider<IdentifiedUser> self, WatchConfig.Accessor watchConfig) {
        this.self = self;
        this.watchConfig = watchConfig;
    }

    public List<ProjectWatchInfo> apply(AccountResource rsrc) throws OrmException, AuthException, IOException, ConfigInvalidException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("It is not allowed to list project watches of other users");
        }
        Account.Id accountId = rsrc.getUser().getAccountId();
        ArrayList<ProjectWatchInfo> projectWatchInfos = new ArrayList<ProjectWatchInfo>();
        for (Map.Entry<WatchConfig.ProjectWatchKey, Set<WatchConfig.NotifyType>> e : this.watchConfig.getProjectWatches(accountId).entrySet()) {
            ProjectWatchInfo pwi = new ProjectWatchInfo();
            pwi.filter = e.getKey().filter();
            pwi.project = e.getKey().project().get();
            pwi.notifyAbandonedChanges = GetWatchedProjects.toBoolean(e.getValue().contains((Object)WatchConfig.NotifyType.ABANDONED_CHANGES));
            pwi.notifyNewChanges = GetWatchedProjects.toBoolean(e.getValue().contains((Object)WatchConfig.NotifyType.NEW_CHANGES));
            pwi.notifyNewPatchSets = GetWatchedProjects.toBoolean(e.getValue().contains((Object)WatchConfig.NotifyType.NEW_PATCHSETS));
            pwi.notifySubmittedChanges = GetWatchedProjects.toBoolean(e.getValue().contains((Object)WatchConfig.NotifyType.SUBMITTED_CHANGES));
            pwi.notifyAllComments = GetWatchedProjects.toBoolean(e.getValue().contains((Object)WatchConfig.NotifyType.ALL_COMMENTS));
            projectWatchInfos.add(pwi);
        }
        Collections.sort(projectWatchInfos, new Comparator<ProjectWatchInfo>(){

            @Override
            public int compare(ProjectWatchInfo pwi1, ProjectWatchInfo pwi2) {
                return ComparisonChain.start().compare((Comparable<?>)((Object)pwi1.project), (Comparable<?>)((Object)pwi2.project)).compare((Comparable<?>)((Object)Strings.nullToEmpty(pwi1.filter)), (Comparable<?>)((Object)Strings.nullToEmpty(pwi2.filter))).result();
            }
        });
        return projectWatchInfos;
    }

    private static Boolean toBoolean(boolean value) {
        return value ? Boolean.valueOf(true) : null;
    }
}

