/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.account.GroupIncludeCache;
import com.google.gerrit.server.cache.CacheModule;
import com.google.gwtorm.server.OrmException;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Named;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class GroupIncludeCacheImpl
implements GroupIncludeCache {
    private static final Logger log = LoggerFactory.getLogger(GroupIncludeCacheImpl.class);
    private static final String PARENT_GROUPS_NAME = "groups_byinclude";
    private static final String SUBGROUPS_NAME = "groups_members";
    private static final String EXTERNAL_NAME = "groups_external";
    private final LoadingCache<AccountGroup.UUID, ImmutableList<AccountGroup.UUID>> subgroups;
    private final LoadingCache<AccountGroup.UUID, ImmutableList<AccountGroup.UUID>> parentGroups;
    private final LoadingCache<String, ImmutableList<AccountGroup.UUID>> external;

    public static Module module() {
        return new CacheModule(){

            @Override
            protected void configure() {
                this.cache(GroupIncludeCacheImpl.PARENT_GROUPS_NAME, AccountGroup.UUID.class, new TypeLiteral<ImmutableList<AccountGroup.UUID>>(){}).loader(ParentGroupsLoader.class);
                this.cache(GroupIncludeCacheImpl.SUBGROUPS_NAME, AccountGroup.UUID.class, new TypeLiteral<ImmutableList<AccountGroup.UUID>>(){}).loader(SubgroupsLoader.class);
                this.cache(GroupIncludeCacheImpl.EXTERNAL_NAME, String.class, new TypeLiteral<ImmutableList<AccountGroup.UUID>>(){}).loader(AllExternalLoader.class);
                this.bind(GroupIncludeCacheImpl.class);
                this.bind(GroupIncludeCache.class).to(GroupIncludeCacheImpl.class);
            }
        };
    }

    @Inject
    GroupIncludeCacheImpl(@Named(value="groups_members") LoadingCache<AccountGroup.UUID, ImmutableList<AccountGroup.UUID>> subgroups, @Named(value="groups_byinclude") LoadingCache<AccountGroup.UUID, ImmutableList<AccountGroup.UUID>> parentGroups, @Named(value="groups_external") LoadingCache<String, ImmutableList<AccountGroup.UUID>> external) {
        this.subgroups = subgroups;
        this.parentGroups = parentGroups;
        this.external = external;
    }

    @Override
    public Collection<AccountGroup.UUID> subgroupsOf(AccountGroup.UUID groupId) {
        try {
            return this.subgroups.get(groupId);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load members of group", e);
            return Collections.emptySet();
        }
    }

    @Override
    public Collection<AccountGroup.UUID> parentGroupsOf(AccountGroup.UUID groupId) {
        try {
            return this.parentGroups.get(groupId);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load included groups", e);
            return Collections.emptySet();
        }
    }

    @Override
    public void evictSubgroupsOf(AccountGroup.UUID groupId) {
        if (groupId != null) {
            this.subgroups.invalidate(groupId);
        }
    }

    @Override
    public void evictParentGroupsOf(AccountGroup.UUID groupId) {
        if (groupId != null) {
            this.parentGroups.invalidate(groupId);
            if (!AccountGroup.isInternalGroup(groupId)) {
                this.external.invalidate(EXTERNAL_NAME);
            }
        }
    }

    @Override
    public Collection<AccountGroup.UUID> allExternalMembers() {
        try {
            return this.external.get(EXTERNAL_NAME);
        }
        catch (ExecutionException e) {
            log.warn("Cannot load set of non-internal groups", e);
            return ImmutableList.of();
        }
    }

    static class AllExternalLoader
    extends CacheLoader<String, ImmutableList<AccountGroup.UUID>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        AllExternalLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        @Override
        public ImmutableList<AccountGroup.UUID> load(String key) throws Exception {
            try (ReviewDb db = this.schema.open();){
                HashSet<AccountGroup.UUID> ids = new HashSet<AccountGroup.UUID>();
                for (AccountGroupById agi : db.accountGroupById().all()) {
                    if (AccountGroup.isInternalGroup(agi.getIncludeUUID())) continue;
                    ids.add(agi.getIncludeUUID());
                }
                ImmutableList immutableList = ImmutableList.copyOf(ids);
                return immutableList;
            }
        }
    }

    static class ParentGroupsLoader
    extends CacheLoader<AccountGroup.UUID, ImmutableList<AccountGroup.UUID>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        ParentGroupsLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        @Override
        public ImmutableList<AccountGroup.UUID> load(AccountGroup.UUID key) throws OrmException {
            try (ReviewDb db = this.schema.open();){
                HashSet<AccountGroup.Id> ids = new HashSet<AccountGroup.Id>();
                for (AccountGroupById agi : db.accountGroupById().byIncludeUUID(key)) {
                    ids.add(agi.getGroupId());
                }
                HashSet<AccountGroup.UUID> groupArray = new HashSet<AccountGroup.UUID>();
                for (AccountGroup g : db.accountGroups().get(ids)) {
                    groupArray.add(g.getGroupUUID());
                }
                ImmutableList immutableList = ImmutableList.copyOf(groupArray);
                return immutableList;
            }
        }
    }

    static class SubgroupsLoader
    extends CacheLoader<AccountGroup.UUID, ImmutableList<AccountGroup.UUID>> {
        private final SchemaFactory<ReviewDb> schema;

        @Inject
        SubgroupsLoader(SchemaFactory<ReviewDb> sf) {
            this.schema = sf;
        }

        @Override
        public ImmutableList<AccountGroup.UUID> load(AccountGroup.UUID key) throws OrmException {
            try (ReviewDb db = this.schema.open();){
                List<AccountGroup> group = db.accountGroups().byUUID(key).toList();
                if (group.size() != 1) {
                    ImmutableList<AccountGroup.UUID> immutableList = ImmutableList.of();
                    return immutableList;
                }
                HashSet<AccountGroup.UUID> ids = new HashSet<AccountGroup.UUID>();
                for (AccountGroupById agi : db.accountGroupById().byGroup(group.get(0).getId())) {
                    ids.add(agi.getIncludeUUID());
                }
                ImmutableList immutableList = ImmutableList.copyOf(ids);
                return immutableList;
            }
        }
    }
}

