/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.gerrit.extensions.client.ProjectWatchInfo;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GetWatchedProjects;
import com.google.gerrit.server.account.WatchConfig;
import com.google.gerrit.server.project.ProjectsCollection;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jgit.errors.ConfigInvalidException;

@Singleton
public class PostWatchedProjects
implements RestModifyView<AccountResource, List<ProjectWatchInfo>> {
    private final Provider<IdentifiedUser> self;
    private final GetWatchedProjects getWatchedProjects;
    private final ProjectsCollection projectsCollection;
    private final AccountCache accountCache;
    private final WatchConfig.Accessor watchConfig;

    @Inject
    public PostWatchedProjects(Provider<IdentifiedUser> self, GetWatchedProjects getWatchedProjects, ProjectsCollection projectsCollection, AccountCache accountCache, WatchConfig.Accessor watchConfig) {
        this.self = self;
        this.getWatchedProjects = getWatchedProjects;
        this.projectsCollection = projectsCollection;
        this.accountCache = accountCache;
        this.watchConfig = watchConfig;
    }

    public List<ProjectWatchInfo> apply(AccountResource rsrc, List<ProjectWatchInfo> input) throws OrmException, RestApiException, IOException, ConfigInvalidException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canAdministrateServer()) {
            throw new AuthException("not allowed to edit project watches");
        }
        Account.Id accountId = rsrc.getUser().getAccountId();
        this.watchConfig.upsertProjectWatches(accountId, this.asMap(input));
        this.accountCache.evict(accountId);
        return this.getWatchedProjects.apply(rsrc);
    }

    private Map<WatchConfig.ProjectWatchKey, Set<WatchConfig.NotifyType>> asMap(List<ProjectWatchInfo> input) throws BadRequestException, UnprocessableEntityException, IOException {
        HashMap<WatchConfig.ProjectWatchKey, Set<WatchConfig.NotifyType>> m = new HashMap<WatchConfig.ProjectWatchKey, Set<WatchConfig.NotifyType>>();
        for (ProjectWatchInfo info : input) {
            if (info.project == null) {
                throw new BadRequestException("project name must be specified");
            }
            WatchConfig.ProjectWatchKey key = WatchConfig.ProjectWatchKey.create(this.projectsCollection.parse(info.project).getNameKey(), info.filter);
            if (m.containsKey(key)) {
                throw new BadRequestException("duplicate entry for project " + PostWatchedProjects.format(info.project, info.filter));
            }
            EnumSet<WatchConfig.NotifyType> notifyValues = EnumSet.noneOf(WatchConfig.NotifyType.class);
            if (this.toBoolean(info.notifyAbandonedChanges)) {
                notifyValues.add(WatchConfig.NotifyType.ABANDONED_CHANGES);
            }
            if (this.toBoolean(info.notifyAllComments)) {
                notifyValues.add(WatchConfig.NotifyType.ALL_COMMENTS);
            }
            if (this.toBoolean(info.notifyNewChanges)) {
                notifyValues.add(WatchConfig.NotifyType.NEW_CHANGES);
            }
            if (this.toBoolean(info.notifyNewPatchSets)) {
                notifyValues.add(WatchConfig.NotifyType.NEW_PATCHSETS);
            }
            if (this.toBoolean(info.notifySubmittedChanges)) {
                notifyValues.add(WatchConfig.NotifyType.SUBMITTED_CHANGES);
            }
            m.put(key, notifyValues);
        }
        return m;
    }

    private boolean toBoolean(Boolean b) {
        return b == null ? false : b;
    }

    private static String format(String project, String filter) {
        return project + (filter != null && !"*".equals(filter) ? " and filter " + filter : "");
    }
}

