/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.account;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.client.GeneralPreferencesInfo;
import com.google.gerrit.extensions.client.MenuItem;
import com.google.gerrit.extensions.config.DownloadScheme;
import com.google.gerrit.extensions.registration.DynamicMap;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.AccountCache;
import com.google.gerrit.server.account.AccountResource;
import com.google.gerrit.server.account.GeneralPreferencesLoader;
import com.google.gerrit.server.account.VersionedAccountPreferences;
import com.google.gerrit.server.config.AllUsersName;
import com.google.gerrit.server.config.ConfigUtil;
import com.google.gerrit.server.git.MetaDataUpdate;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.Config;

@Singleton
public class SetPreferences
implements RestModifyView<AccountResource, GeneralPreferencesInfo> {
    private final Provider<CurrentUser> self;
    private final AccountCache cache;
    private final GeneralPreferencesLoader loader;
    private final Provider<MetaDataUpdate.User> metaDataUpdateFactory;
    private final AllUsersName allUsersName;
    private final DynamicMap<DownloadScheme> downloadSchemes;

    @Inject
    SetPreferences(Provider<CurrentUser> self, AccountCache cache, GeneralPreferencesLoader loader, Provider<MetaDataUpdate.User> metaDataUpdateFactory, AllUsersName allUsersName, DynamicMap<DownloadScheme> downloadSchemes) {
        this.self = self;
        this.loader = loader;
        this.cache = cache;
        this.metaDataUpdateFactory = metaDataUpdateFactory;
        this.allUsersName = allUsersName;
        this.downloadSchemes = downloadSchemes;
    }

    public GeneralPreferencesInfo apply(AccountResource rsrc, GeneralPreferencesInfo i) throws AuthException, BadRequestException, IOException, ConfigInvalidException {
        if (!this.self.get().hasSameAccountId(rsrc.getUser()) && !this.self.get().getCapabilities().canModifyAccount()) {
            throw new AuthException("requires Modify Account capability");
        }
        this.checkDownloadScheme(i.downloadScheme);
        Account.Id id = rsrc.getUser().getAccountId();
        GeneralPreferencesInfo n = this.loader.merge(id, i);
        n.changeTable = i.changeTable;
        n.my = i.my;
        n.urlAliases = i.urlAliases;
        this.writeToGit(id, n);
        return this.cache.get(id).getAccount().getGeneralPreferencesInfo();
    }

    private void writeToGit(Account.Id id, GeneralPreferencesInfo i) throws RepositoryNotFoundException, IOException, ConfigInvalidException {
        try (MetaDataUpdate md = this.metaDataUpdateFactory.get().create(this.allUsersName);){
            VersionedAccountPreferences prefs = VersionedAccountPreferences.forUser(id);
            prefs.load(md);
            ConfigUtil.storeSection(prefs.getConfig(), "general", null, i, this.loader.readDefaultsFromGit(md.getRepository(), null));
            SetPreferences.storeMyChangeTableColumns(prefs, i.changeTable);
            SetPreferences.storeMyMenus(prefs, i.my);
            SetPreferences.storeUrlAliases(prefs, i.urlAliases);
            prefs.commit(md);
            this.cache.evict(id);
        }
    }

    public static void storeMyMenus(VersionedAccountPreferences prefs, List<MenuItem> my) {
        Config cfg = prefs.getConfig();
        if (my != null) {
            SetPreferences.unsetSection(cfg, "my");
            for (MenuItem item : my) {
                SetPreferences.set(cfg, item.name, "url", item.url);
                SetPreferences.set(cfg, item.name, "target", item.target);
                SetPreferences.set(cfg, item.name, "id", item.id);
            }
        }
    }

    public static void storeMyChangeTableColumns(VersionedAccountPreferences prefs, List<String> changeTable) {
        Config cfg = prefs.getConfig();
        if (changeTable != null) {
            SetPreferences.unsetSection(cfg, "changeTable");
            cfg.setStringList("changeTable", null, "column", changeTable);
        }
    }

    private static void set(Config cfg, String section, String key, String val) {
        if (Strings.isNullOrEmpty(val)) {
            cfg.unset("my", section, key);
        } else {
            cfg.setString("my", section, key, val);
        }
    }

    private static void unsetSection(Config cfg, String section) {
        cfg.unsetSection(section, null);
        for (String subsection : cfg.getSubsections(section)) {
            cfg.unsetSection(section, subsection);
        }
    }

    public static void storeUrlAliases(VersionedAccountPreferences prefs, Map<String, String> urlAliases) {
        if (urlAliases != null) {
            Config cfg = prefs.getConfig();
            for (String subsection : cfg.getSubsections("urlAlias")) {
                cfg.unsetSection("urlAlias", subsection);
            }
            int i = 1;
            for (Map.Entry<String, String> e : urlAliases.entrySet()) {
                cfg.setString("urlAlias", "urlAlias" + i, "match", e.getKey());
                cfg.setString("urlAlias", "urlAlias" + i, "token", e.getValue());
                ++i;
            }
        }
    }

    private void checkDownloadScheme(String downloadScheme) throws BadRequestException {
        if (Strings.isNullOrEmpty(downloadScheme)) {
            return;
        }
        for (DynamicMap.Entry<DownloadScheme> entry : this.downloadSchemes) {
            if (!entry.getExportName().equals(downloadScheme) || !entry.getProvider().get().isEnabled()) continue;
            return;
        }
        throw new BadRequestException("Unsupported download scheme: " + downloadScheme);
    }
}

