/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.api.groups;

import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.extensions.api.groups.GroupApi;
import com.google.gerrit.extensions.common.AccountInfo;
import com.google.gerrit.extensions.common.GroupAuditEventInfo;
import com.google.gerrit.extensions.common.GroupInfo;
import com.google.gerrit.extensions.common.GroupOptionsInfo;
import com.google.gerrit.extensions.restapi.ResourceNotFoundException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.server.group.AddIncludedGroups;
import com.google.gerrit.server.group.AddMembers;
import com.google.gerrit.server.group.DeleteIncludedGroups;
import com.google.gerrit.server.group.DeleteMembers;
import com.google.gerrit.server.group.GetAuditLog;
import com.google.gerrit.server.group.GetDescription;
import com.google.gerrit.server.group.GetDetail;
import com.google.gerrit.server.group.GetGroup;
import com.google.gerrit.server.group.GetName;
import com.google.gerrit.server.group.GetOptions;
import com.google.gerrit.server.group.GetOwner;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.Index;
import com.google.gerrit.server.group.ListIncludedGroups;
import com.google.gerrit.server.group.ListMembers;
import com.google.gerrit.server.group.PutDescription;
import com.google.gerrit.server.group.PutName;
import com.google.gerrit.server.group.PutOptions;
import com.google.gerrit.server.group.PutOwner;
import com.google.gwtorm.server.OrmException;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

class GroupApiImpl
implements GroupApi {
    private final GetGroup getGroup;
    private final GetDetail getDetail;
    private final GetName getName;
    private final PutName putName;
    private final GetOwner getOwner;
    private final PutOwner putOwner;
    private final GetDescription getDescription;
    private final PutDescription putDescription;
    private final GetOptions getOptions;
    private final PutOptions putOptions;
    private final ListMembers listMembers;
    private final AddMembers addMembers;
    private final DeleteMembers deleteMembers;
    private final ListIncludedGroups listGroups;
    private final AddIncludedGroups addGroups;
    private final DeleteIncludedGroups deleteGroups;
    private final GetAuditLog getAuditLog;
    private final GroupResource rsrc;
    private final Index index;

    @AssistedInject
    GroupApiImpl(GetGroup getGroup, GetDetail getDetail, GetName getName, PutName putName, GetOwner getOwner, PutOwner putOwner, GetDescription getDescription, PutDescription putDescription, GetOptions getOptions, PutOptions putOptions, ListMembers listMembers, AddMembers addMembers, DeleteMembers deleteMembers, ListIncludedGroups listGroups, AddIncludedGroups addGroups, DeleteIncludedGroups deleteGroups, GetAuditLog getAuditLog, Index index, @Assisted GroupResource rsrc) {
        this.getGroup = getGroup;
        this.getDetail = getDetail;
        this.getName = getName;
        this.putName = putName;
        this.getOwner = getOwner;
        this.putOwner = putOwner;
        this.getDescription = getDescription;
        this.putDescription = putDescription;
        this.getOptions = getOptions;
        this.putOptions = putOptions;
        this.listMembers = listMembers;
        this.addMembers = addMembers;
        this.deleteMembers = deleteMembers;
        this.listGroups = listGroups;
        this.addGroups = addGroups;
        this.deleteGroups = deleteGroups;
        this.getAuditLog = getAuditLog;
        this.index = index;
        this.rsrc = rsrc;
    }

    @Override
    public GroupInfo get() throws RestApiException {
        try {
            return this.getGroup.apply(this.rsrc);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve group", e);
        }
    }

    @Override
    public GroupInfo detail() throws RestApiException {
        try {
            return this.getDetail.apply(this.rsrc);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot retrieve group", e);
        }
    }

    @Override
    public String name() throws RestApiException {
        return this.getName.apply(this.rsrc);
    }

    @Override
    public void name(String name) throws RestApiException {
        PutName.Input in = new PutName.Input();
        in.name = name;
        try {
            this.putName.apply(this.rsrc, in);
        }
        catch (NoSuchGroupException e) {
            throw new ResourceNotFoundException(name, e);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot put group name", e);
        }
    }

    @Override
    public GroupInfo owner() throws RestApiException {
        try {
            return this.getOwner.apply(this.rsrc);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get group owner", e);
        }
    }

    @Override
    public void owner(String owner) throws RestApiException {
        PutOwner.Input in = new PutOwner.Input();
        in.owner = owner;
        try {
            this.putOwner.apply(this.rsrc, in);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot put group owner", e);
        }
    }

    @Override
    public String description() throws RestApiException {
        return this.getDescription.apply(this.rsrc);
    }

    @Override
    public void description(String description) throws RestApiException {
        PutDescription.Input in = new PutDescription.Input();
        in.description = description;
        try {
            this.putDescription.apply(this.rsrc, in);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot put group description", e);
        }
    }

    @Override
    public GroupOptionsInfo options() throws RestApiException {
        return this.getOptions.apply(this.rsrc);
    }

    @Override
    public void options(GroupOptionsInfo options) throws RestApiException {
        try {
            this.putOptions.apply(this.rsrc, options);
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot put group options", e);
        }
    }

    @Override
    public List<AccountInfo> members() throws RestApiException {
        return this.members(false);
    }

    @Override
    public List<AccountInfo> members(boolean recursive) throws RestApiException {
        this.listMembers.setRecursive(recursive);
        try {
            return this.listMembers.apply(this.rsrc);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot list group members", e);
        }
    }

    @Override
    public void addMembers(String ... members) throws RestApiException {
        try {
            this.addMembers.apply(this.rsrc, AddMembers.Input.fromMembers(Arrays.asList(members)));
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot add group members", e);
        }
    }

    @Override
    public void removeMembers(String ... members) throws RestApiException {
        try {
            this.deleteMembers.apply(this.rsrc, AddMembers.Input.fromMembers(Arrays.asList(members)));
        }
        catch (OrmException | IOException e) {
            throw new RestApiException("Cannot remove group members", e);
        }
    }

    @Override
    public List<GroupInfo> includedGroups() throws RestApiException {
        try {
            return this.listGroups.apply(this.rsrc);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot list included groups", e);
        }
    }

    @Override
    public void addGroups(String ... groups) throws RestApiException {
        try {
            this.addGroups.apply(this.rsrc, AddIncludedGroups.Input.fromGroups(Arrays.asList(groups)));
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot add group members", e);
        }
    }

    @Override
    public void removeGroups(String ... groups) throws RestApiException {
        try {
            this.deleteGroups.apply(this.rsrc, AddIncludedGroups.Input.fromGroups(Arrays.asList(groups)));
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot remove group members", e);
        }
    }

    @Override
    public List<? extends GroupAuditEventInfo> auditLog() throws RestApiException {
        try {
            return this.getAuditLog.apply(this.rsrc);
        }
        catch (OrmException e) {
            throw new RestApiException("Cannot get audit log", e);
        }
    }

    @Override
    public void index() throws RestApiException {
        try {
            this.index.apply(this.rsrc, new Index.Input());
        }
        catch (IOException e) {
            throw new RestApiException("Cannot index group", e);
        }
    }

    static interface Factory {
        public GroupApiImpl create(GroupResource var1);
    }
}

