/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.args4j;

import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.common.errors.NoSuchGroupException;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.server.account.GroupBackend;
import com.google.gerrit.server.account.GroupBackends;
import com.google.gerrit.server.account.GroupControl;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;

public class AccountGroupUUIDHandler
extends OptionHandler<AccountGroup.UUID> {
    private final GroupBackend groupBackend;
    private final GroupControl.Factory groupControlFactory;

    @Inject
    public AccountGroupUUIDHandler(GroupBackend groupBackend, GroupControl.Factory groupControlFactory, @Assisted CmdLineParser parser, @Assisted OptionDef option, @Assisted Setter<AccountGroup.UUID> setter) {
        super(parser, option, setter);
        this.groupBackend = groupBackend;
        this.groupControlFactory = groupControlFactory;
    }

    @Override
    public final int parseArguments(Parameters params) throws CmdLineException {
        GroupReference group;
        GroupDescription.Basic d;
        String n = params.getParameter(0);
        AccountGroup.UUID uuid = new AccountGroup.UUID(n);
        if (this.groupBackend.handles(uuid) && (d = this.groupBackend.get(uuid)) != null) {
            this.setter.addValue(uuid);
            return 1;
        }
        if (n.matches("^[1-9][0-9]*$")) {
            try {
                AccountGroup.Id legacyId = AccountGroup.Id.parse(n);
                uuid = this.groupControlFactory.controlFor(legacyId).getGroup().getGroupUUID();
                this.setter.addValue(uuid);
                return 1;
            }
            catch (NoSuchGroupException | IllegalArgumentException legacyId) {
                // empty catch block
            }
        }
        if ((group = GroupBackends.findExactSuggestion(this.groupBackend, n)) == null) {
            throw new CmdLineException(this.owner, "Group \"" + n + "\" does not exist");
        }
        this.setter.addValue(group.getUUID());
        return 1;
    }

    @Override
    public final String getDefaultMetaVariable() {
        return "GROUP";
    }
}

