/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gerrit.common.FooterConstants;
import com.google.gerrit.common.data.LabelType;
import com.google.gerrit.common.data.LabelTypes;
import com.google.gerrit.extensions.api.changes.NotifyHandling;
import com.google.gerrit.extensions.api.changes.RecipientType;
import com.google.gerrit.extensions.restapi.ResourceConflictException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.Branch;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.ChangeMessage;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.PatchSetInfo;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.ApprovalsUtil;
import com.google.gerrit.server.ChangeMessagesUtil;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.PatchSetUtil;
import com.google.gerrit.server.events.CommitReceivedEvent;
import com.google.gerrit.server.extensions.events.CommentAdded;
import com.google.gerrit.server.extensions.events.RevisionCreated;
import com.google.gerrit.server.git.GroupCollector;
import com.google.gerrit.server.git.SendEmailExecutor;
import com.google.gerrit.server.git.validators.CommitValidationException;
import com.google.gerrit.server.git.validators.CommitValidators;
import com.google.gerrit.server.mail.send.CreateChangeSender;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.notedb.ChangeUpdate;
import com.google.gerrit.server.notedb.ReviewerStateInternal;
import com.google.gerrit.server.patch.PatchSetInfoFactory;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gerrit.server.project.ProjectControl;
import com.google.gerrit.server.project.RefControl;
import com.google.gerrit.server.ssh.NoSshInfo;
import com.google.gerrit.server.update.ChangeContext;
import com.google.gerrit.server.update.Context;
import com.google.gerrit.server.update.InsertChangeOp;
import com.google.gerrit.server.update.RepoContext;
import com.google.gerrit.server.util.RequestScopePropagator;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.eclipse.jgit.util.ChangeIdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangeInserter
implements InsertChangeOp {
    private static final Logger log = LoggerFactory.getLogger(ChangeInserter.class);
    private final ProjectControl.GenericFactory projectControlFactory;
    private final IdentifiedUser.GenericFactory userFactory;
    private final ChangeControl.GenericFactory changeControlFactory;
    private final PatchSetInfoFactory patchSetInfoFactory;
    private final PatchSetUtil psUtil;
    private final ApprovalsUtil approvalsUtil;
    private final ChangeMessagesUtil cmUtil;
    private final CreateChangeSender.Factory createChangeSenderFactory;
    private final ExecutorService sendEmailExecutor;
    private final CommitValidators.Factory commitValidatorsFactory;
    private final RevisionCreated revisionCreated;
    private final CommentAdded commentAdded;
    private final Change.Id changeId;
    private final PatchSet.Id psId;
    private final RevCommit commit;
    private final String refName;
    private Change.Status status;
    private String topic;
    private String message;
    private String patchSetDescription;
    private List<String> groups = Collections.emptyList();
    private CommitValidators.Policy validatePolicy = CommitValidators.Policy.GERRIT;
    private NotifyHandling notify = NotifyHandling.ALL;
    private ListMultimap<RecipientType, Account.Id> accountsToNotify = ImmutableListMultimap.of();
    private Set<Account.Id> reviewers;
    private Set<Account.Id> extraCC;
    private Map<String, Short> approvals;
    private RequestScopePropagator requestScopePropagator;
    private ReceiveCommand updateRefCommand;
    private boolean fireRevisionCreated;
    private boolean sendMail;
    private boolean updateRef;
    private Change change;
    private ChangeMessage changeMessage;
    private PatchSetInfo patchSetInfo;
    private PatchSet patchSet;
    private String pushCert;

    @Inject
    ChangeInserter(ProjectControl.GenericFactory projectControlFactory, IdentifiedUser.GenericFactory userFactory, ChangeControl.GenericFactory changeControlFactory, PatchSetInfoFactory patchSetInfoFactory, PatchSetUtil psUtil, ApprovalsUtil approvalsUtil, ChangeMessagesUtil cmUtil, CreateChangeSender.Factory createChangeSenderFactory, @SendEmailExecutor ExecutorService sendEmailExecutor, CommitValidators.Factory commitValidatorsFactory, CommentAdded commentAdded, RevisionCreated revisionCreated, @Assisted Change.Id changeId, @Assisted RevCommit commit, @Assisted String refName) {
        this.projectControlFactory = projectControlFactory;
        this.userFactory = userFactory;
        this.changeControlFactory = changeControlFactory;
        this.patchSetInfoFactory = patchSetInfoFactory;
        this.psUtil = psUtil;
        this.approvalsUtil = approvalsUtil;
        this.cmUtil = cmUtil;
        this.createChangeSenderFactory = createChangeSenderFactory;
        this.sendEmailExecutor = sendEmailExecutor;
        this.commitValidatorsFactory = commitValidatorsFactory;
        this.revisionCreated = revisionCreated;
        this.commentAdded = commentAdded;
        this.changeId = changeId;
        this.psId = new PatchSet.Id(changeId, 1);
        this.commit = commit;
        this.refName = refName;
        this.reviewers = Collections.emptySet();
        this.extraCC = Collections.emptySet();
        this.approvals = Collections.emptyMap();
        this.updateRefCommand = null;
        this.fireRevisionCreated = true;
        this.sendMail = true;
        this.updateRef = true;
    }

    @Override
    public Change createChange(Context ctx) {
        this.change = new Change(ChangeInserter.getChangeKey(this.commit), this.changeId, ctx.getAccountId(), new Branch.NameKey(ctx.getProject(), this.refName), ctx.getWhen());
        this.change.setStatus(MoreObjects.firstNonNull(this.status, Change.Status.NEW));
        this.change.setTopic(this.topic);
        return this.change;
    }

    private static Change.Key getChangeKey(RevCommit commit) {
        List<String> idList = commit.getFooterLines(FooterConstants.CHANGE_ID);
        if (!idList.isEmpty()) {
            return new Change.Key(idList.get(idList.size() - 1).trim());
        }
        ObjectId id = ChangeIdUtil.computeChangeId(commit.getTree(), commit, commit.getAuthorIdent(), commit.getCommitterIdent(), commit.getShortMessage());
        StringBuilder changeId = new StringBuilder();
        changeId.append("I").append(ObjectId.toString(id));
        return new Change.Key(changeId.toString());
    }

    public PatchSet.Id getPatchSetId() {
        return this.psId;
    }

    public RevCommit getCommit() {
        return this.commit;
    }

    public Change getChange() {
        Preconditions.checkState(this.change != null, "getChange() only valid after creating change");
        return this.change;
    }

    public ChangeInserter setTopic(String topic) {
        Preconditions.checkState(this.change == null, "setTopic(String) only valid before creating change");
        this.topic = topic;
        return this;
    }

    public ChangeInserter setMessage(String message) {
        this.message = message;
        return this;
    }

    public ChangeInserter setPatchSetDescription(String patchSetDescription) {
        this.patchSetDescription = patchSetDescription;
        return this;
    }

    public ChangeInserter setValidatePolicy(CommitValidators.Policy validate) {
        this.validatePolicy = Preconditions.checkNotNull(validate);
        return this;
    }

    public ChangeInserter setNotify(NotifyHandling notify) {
        this.notify = notify;
        return this;
    }

    public ChangeInserter setAccountsToNotify(ListMultimap<RecipientType, Account.Id> accountsToNotify) {
        this.accountsToNotify = Preconditions.checkNotNull(accountsToNotify);
        return this;
    }

    public ChangeInserter setReviewers(Set<Account.Id> reviewers) {
        this.reviewers = reviewers;
        return this;
    }

    public ChangeInserter setExtraCC(Set<Account.Id> extraCC) {
        this.extraCC = extraCC;
        return this;
    }

    public ChangeInserter setDraft(boolean draft) {
        Preconditions.checkState(this.change == null, "setDraft(boolean) only valid before creating change");
        return this.setStatus(draft ? Change.Status.DRAFT : Change.Status.NEW);
    }

    public ChangeInserter setStatus(Change.Status status) {
        Preconditions.checkState(this.change == null, "setStatus(Change.Status) only valid before creating change");
        this.status = status;
        return this;
    }

    public ChangeInserter setGroups(List<String> groups) {
        Preconditions.checkNotNull(groups, "groups may not be empty");
        Preconditions.checkState(this.patchSet == null, "setGroups(Iterable<String>) only valid before creating change");
        this.groups = groups;
        return this;
    }

    public ChangeInserter setFireRevisionCreated(boolean fireRevisionCreated) {
        this.fireRevisionCreated = fireRevisionCreated;
        return this;
    }

    public ChangeInserter setSendMail(boolean sendMail) {
        this.sendMail = sendMail;
        return this;
    }

    public ChangeInserter setRequestScopePropagator(RequestScopePropagator r) {
        this.requestScopePropagator = r;
        return this;
    }

    public void setUpdateRefCommand(ReceiveCommand cmd) {
        this.updateRefCommand = cmd;
    }

    public void setPushCertificate(String cert) {
        this.pushCert = cert;
    }

    public PatchSet getPatchSet() {
        Preconditions.checkState(this.patchSet != null, "getPatchSet() only valid after creating change");
        return this.patchSet;
    }

    public ChangeInserter setApprovals(Map<String, Short> approvals) {
        this.approvals = approvals;
        return this;
    }

    public ChangeInserter setUpdateRef(boolean updateRef) {
        this.updateRef = updateRef;
        return this;
    }

    public ChangeMessage getChangeMessage() {
        if (this.message == null) {
            return null;
        }
        Preconditions.checkState(this.changeMessage != null, "getChangeMessage() only valid after inserting change");
        return this.changeMessage;
    }

    @Override
    public void updateRepo(RepoContext ctx) throws ResourceConflictException, IOException {
        this.validate(ctx);
        if (!this.updateRef) {
            return;
        }
        if (this.updateRefCommand == null) {
            ctx.addRefUpdate(new ReceiveCommand(ObjectId.zeroId(), this.commit, this.psId.toRefName()));
        } else {
            ctx.addRefUpdate(this.updateRefCommand);
        }
    }

    @Override
    public boolean updateChange(ChangeContext ctx) throws RestApiException, OrmException, IOException {
        this.change = ctx.getChange();
        ReviewDb db = ctx.getDb();
        ChangeControl ctl = ctx.getControl();
        this.patchSetInfo = this.patchSetInfoFactory.get(ctx.getRevWalk(), this.commit, this.psId);
        ctx.getChange().setCurrentPatchSet(this.patchSetInfo);
        ChangeUpdate update = ctx.getUpdate(this.psId);
        update.setChangeId(this.change.getKey().get());
        update.setSubjectForCommit("Create change");
        update.setBranch(this.change.getDest().get());
        update.setTopic(this.change.getTopic());
        update.setPsDescription(this.patchSetDescription);
        boolean draft = this.status == Change.Status.DRAFT;
        List<String> newGroups = this.groups;
        if (newGroups.isEmpty()) {
            newGroups = GroupCollector.getDefaultGroups(this.commit);
        }
        this.patchSet = this.psUtil.insert(ctx.getDb(), ctx.getRevWalk(), update, this.psId, this.commit, draft, newGroups, this.pushCert, this.patchSetDescription);
        update.fixStatus(this.change.getStatus());
        LabelTypes labelTypes = ctl.getProjectControl().getLabelTypes();
        this.approvalsUtil.addReviewers(db, update, labelTypes, this.change, this.patchSet, this.patchSetInfo, this.filterOnChangeVisibility(db, ctx.getNotes(), this.reviewers), Collections.emptySet());
        this.approvalsUtil.addApprovalsForNewPatchSet(db, update, labelTypes, this.patchSet, ctx.getControl(), this.approvals);
        if (!this.approvals.isEmpty()) {
            update.putReviewer(ctx.getAccountId(), ReviewerStateInternal.REVIEWER);
        }
        if (this.message != null) {
            this.changeMessage = ChangeMessagesUtil.newMessage(this.patchSet.getId(), ctx.getUser(), this.patchSet.getCreatedOn(), this.message, "autogenerated:gerrit:newPatchSet");
            this.cmUtil.addChangeMessage(db, update, this.changeMessage);
        }
        return true;
    }

    private Set<Account.Id> filterOnChangeVisibility(ReviewDb db, ChangeNotes notes, Set<Account.Id> accounts) {
        return accounts.stream().filter(accountId -> {
            try {
                IdentifiedUser user = this.userFactory.create((Account.Id)accountId);
                return this.changeControlFactory.controlFor(notes, user).isVisible(db);
            }
            catch (OrmException e) {
                log.warn("Failed to check if account {} can see change {}", accountId.get(), notes.getChangeId().get(), e);
                return false;
            }
        }).collect(Collectors.toSet());
    }

    @Override
    public void postUpdate(Context ctx) throws OrmException {
        if (this.sendMail && (this.notify != NotifyHandling.NONE || !this.accountsToNotify.isEmpty())) {
            Runnable sender = new Runnable(){

                @Override
                public void run() {
                    try {
                        CreateChangeSender cm = ChangeInserter.this.createChangeSenderFactory.create(ChangeInserter.this.change.getProject(), ChangeInserter.this.change.getId());
                        cm.setFrom(ChangeInserter.this.change.getOwner());
                        cm.setPatchSet(ChangeInserter.this.patchSet, ChangeInserter.this.patchSetInfo);
                        cm.setNotify(ChangeInserter.this.notify);
                        cm.setAccountsToNotify(ChangeInserter.this.accountsToNotify);
                        cm.addReviewers(ChangeInserter.this.reviewers);
                        cm.addExtraCC(ChangeInserter.this.extraCC);
                        cm.send();
                    }
                    catch (Exception e) {
                        log.error("Cannot send email for new change {}", (Object)ChangeInserter.this.change.getId(), (Object)e);
                    }
                }

                public String toString() {
                    return "send-email newchange";
                }
            };
            if (this.requestScopePropagator != null) {
                Future<?> future = this.sendEmailExecutor.submit(this.requestScopePropagator.wrap(sender));
            } else {
                sender.run();
            }
        }
        if (this.fireRevisionCreated) {
            this.revisionCreated.fire(this.change, this.patchSet, ctx.getAccount(), ctx.getWhen(), this.notify);
            if (this.approvals != null && !this.approvals.isEmpty()) {
                ChangeControl changeControl = this.changeControlFactory.controlFor(ctx.getDb(), this.change, ctx.getUser());
                List<LabelType> labels = changeControl.getLabelTypes().getLabelTypes();
                HashMap<String, Short> allApprovals = new HashMap<String, Short>();
                HashMap<String, Short> oldApprovals = new HashMap<String, Short>();
                for (LabelType labelType : labels) {
                    allApprovals.put(labelType.getName(), (short)0);
                    oldApprovals.put(labelType.getName(), null);
                }
                for (Map.Entry entry : this.approvals.entrySet()) {
                    if ((Short)entry.getValue() == 0) continue;
                    allApprovals.put((String)entry.getKey(), (Short)entry.getValue());
                    oldApprovals.put((String)entry.getKey(), (short)0);
                }
                this.commentAdded.fire(this.change, this.patchSet, ctx.getAccount(), null, allApprovals, oldApprovals, ctx.getWhen());
            }
        }
    }

    private void validate(RepoContext ctx) throws IOException, ResourceConflictException {
        if (this.validatePolicy == CommitValidators.Policy.NONE) {
            return;
        }
        try {
            RefControl refControl = this.projectControlFactory.controlFor(ctx.getProject(), ctx.getUser()).controlForRef(this.refName);
            String refName = this.psId.toRefName();
            CommitReceivedEvent event = new CommitReceivedEvent(new ReceiveCommand(ObjectId.zeroId(), this.commit.getId(), refName), refControl.getProjectControl().getProject(), this.change.getDest().get(), this.commit, ctx.getIdentifiedUser());
            this.commitValidatorsFactory.create(this.validatePolicy, refControl, new NoSshInfo(), ctx.getRepository()).validate(event);
        }
        catch (CommitValidationException e) {
            throw new ResourceConflictException(e.getFullMessage());
        }
        catch (NoSuchProjectException e) {
            throw new ResourceConflictException(e.getMessage());
        }
    }

    public static interface Factory {
        public ChangeInserter create(Change.Id var1, RevCommit var2, String var3);
    }
}

