/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.gerrit.extensions.common.RobotCommentInfo;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.RobotComment;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CommentsUtil;
import com.google.gerrit.server.change.CommentJson;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.List;
import java.util.Map;

@Singleton
public class ListRobotComments
implements RestReadView<RevisionResource> {
    protected final Provider<ReviewDb> db;
    protected final Provider<CommentJson> commentJson;
    protected final CommentsUtil commentsUtil;

    @Inject
    ListRobotComments(Provider<ReviewDb> db, Provider<CommentJson> commentJson, CommentsUtil commentsUtil) {
        this.db = db;
        this.commentJson = commentJson;
        this.commentsUtil = commentsUtil;
    }

    public Map<String, List<RobotCommentInfo>> apply(RevisionResource rsrc) throws OrmException {
        return this.commentJson.get().setFillAccounts(true).newRobotCommentFormatter().format(this.listComments(rsrc));
    }

    public List<RobotCommentInfo> getComments(RevisionResource rsrc) throws OrmException {
        return this.commentJson.get().setFillAccounts(true).newRobotCommentFormatter().formatAsList(this.listComments(rsrc));
    }

    private Iterable<RobotComment> listComments(RevisionResource rsrc) throws OrmException {
        return this.commentsUtil.robotCommentsByPatchSet(rsrc.getNotes(), rsrc.getPatchSet().getId());
    }
}

