/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.change;

import com.google.common.base.Strings;
import com.google.gerrit.extensions.api.changes.SubmitInput;
import com.google.gerrit.extensions.restapi.BadRequestException;
import com.google.gerrit.extensions.restapi.BinaryResult;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.NotImplementedException;
import com.google.gerrit.extensions.restapi.PreconditionFailedException;
import com.google.gerrit.extensions.restapi.RestApiException;
import com.google.gerrit.extensions.restapi.RestReadView;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.IdentifiedUser;
import com.google.gerrit.server.change.AllowedFormats;
import com.google.gerrit.server.change.ArchiveFormat;
import com.google.gerrit.server.change.LimitedByteArrayOutputStream;
import com.google.gerrit.server.change.RevisionResource;
import com.google.gerrit.server.change.Submit;
import com.google.gerrit.server.config.GerritServerConfig;
import com.google.gerrit.server.git.MergeOp;
import com.google.gerrit.server.git.MergeOpRepoManager;
import com.google.gerrit.server.project.ChangeControl;
import com.google.gerrit.server.project.NoSuchProjectException;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.apache.commons.compress.archivers.ArchiveOutputStream;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.BundleWriter;
import org.eclipse.jgit.transport.ReceiveCommand;
import org.kohsuke.args4j.Option;

@Singleton
public class PreviewSubmit
implements RestReadView<RevisionResource> {
    private static final int MAX_DEFAULT_BUNDLE_SIZE = 0x6400000;
    private final Provider<ReviewDb> dbProvider;
    private final Provider<MergeOp> mergeOpProvider;
    private final AllowedFormats allowedFormats;
    private int maxBundleSize;
    private String format;

    @Option(name="--format")
    public void setFormat(String f) {
        this.format = f;
    }

    @Inject
    PreviewSubmit(Provider<ReviewDb> dbProvider, Provider<MergeOp> mergeOpProvider, AllowedFormats allowedFormats, @GerritServerConfig Config cfg) {
        this.dbProvider = dbProvider;
        this.mergeOpProvider = mergeOpProvider;
        this.allowedFormats = allowedFormats;
        this.maxBundleSize = cfg.getInt("download", "maxBundleSize", 0x6400000);
    }

    public BinaryResult apply(RevisionResource rsrc) throws OrmException, RestApiException {
        if (Strings.isNullOrEmpty(this.format)) {
            throw new BadRequestException("format is not specified");
        }
        ArchiveFormat f = this.allowedFormats.extensions.get("." + this.format);
        if (f == null && this.format.equals("tgz")) {
            f = ArchiveFormat.TGZ;
        }
        if (f == null) {
            throw new BadRequestException("unknown archive format");
        }
        Change change = rsrc.getChange();
        if (!change.getStatus().isOpen()) {
            throw new PreconditionFailedException("change is " + Submit.status(change));
        }
        ChangeControl control = rsrc.getControl();
        if (!control.getUser().isIdentifiedUser()) {
            throw new MethodNotAllowedException("Anonymous users cannot submit");
        }
        return this.getBundles(rsrc, f);
    }

    private BinaryResult getBundles(RevisionResource rsrc, ArchiveFormat f) throws OrmException, RestApiException {
        ReviewDb db = this.dbProvider.get();
        ChangeControl control = rsrc.getControl();
        IdentifiedUser caller = control.getUser().asIdentifiedUser();
        Change change = rsrc.getChange();
        MergeOp op = this.mergeOpProvider.get();
        try {
            op.merge(db, change, caller, false, new SubmitInput(), true);
            SubmitPreviewResult bin = new SubmitPreviewResult(op, f, this.maxBundleSize);
            bin.disableGzip().setContentType(f.getMimeType()).setAttachmentName("submit-preview-" + change.getChangeId() + "." + this.format);
            return bin;
        }
        catch (RestApiException | OrmException | RuntimeException e) {
            op.close();
            throw e;
        }
    }

    private static class SubmitPreviewResult
    extends BinaryResult {
        private final MergeOp mergeOp;
        private final ArchiveFormat archiveFormat;
        private final int maxBundleSize;

        private SubmitPreviewResult(MergeOp mergeOp, ArchiveFormat archiveFormat, int maxBundleSize) {
            this.mergeOp = mergeOp;
            this.archiveFormat = archiveFormat;
            this.maxBundleSize = maxBundleSize;
        }

        @Override
        public void writeTo(OutputStream out) throws IOException {
            try (ArchiveOutputStream aos = this.archiveFormat.createArchiveOutputStream(out);){
                MergeOpRepoManager orm = this.mergeOp.getMergeOpRepoManager();
                for (Project.NameKey p : this.mergeOp.getAllProjects()) {
                    MergeOpRepoManager.OpenRepo or = orm.getRepo(p);
                    BundleWriter bw = new BundleWriter(or.getRepo());
                    bw.setObjectCountCallback(null);
                    bw.setPackConfig(null);
                    Collection<ReceiveCommand> refs = or.getUpdate().getRefUpdates();
                    for (ReceiveCommand r : refs) {
                        bw.include(r.getRefName(), r.getNewId());
                        ObjectId oldId = r.getOldId();
                        if (oldId.equals(ObjectId.zeroId())) continue;
                        bw.assume(or.getCodeReviewRevWalk().parseCommit(oldId));
                    }
                    LimitedByteArrayOutputStream bos = new LimitedByteArrayOutputStream(this.maxBundleSize, 1024);
                    bw.writeBundle(NullProgressMonitor.INSTANCE, bos);
                    String path = p.get() + ".git";
                    this.archiveFormat.putEntry(aos, path, bos.toByteArray());
                }
            }
            catch (LimitedByteArrayOutputStream.LimitExceededException e) {
                throw new NotImplementedException("The bundle is too big to generate at the server");
            }
            catch (NoSuchProjectException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void close() throws IOException {
            this.mergeOp.close();
        }
    }
}

