/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.edit;

import com.google.common.base.Preconditions;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.PatchSet;
import com.google.gerrit.reviewdb.client.RefNames;
import com.google.gerrit.reviewdb.client.RevId;
import com.google.gerrit.server.IdentifiedUser;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;

public class ChangeEdit {
    private final IdentifiedUser user;
    private final Change change;
    private final Ref ref;
    private final RevCommit editCommit;
    private final PatchSet basePatchSet;

    public ChangeEdit(IdentifiedUser user, Change change, Ref ref, RevCommit editCommit, PatchSet basePatchSet) {
        Preconditions.checkNotNull(user);
        Preconditions.checkNotNull(change);
        Preconditions.checkNotNull(ref);
        Preconditions.checkNotNull(editCommit);
        Preconditions.checkNotNull(basePatchSet);
        this.user = user;
        this.change = change;
        this.ref = ref;
        this.editCommit = editCommit;
        this.basePatchSet = basePatchSet;
    }

    public Change getChange() {
        return this.change;
    }

    public IdentifiedUser getUser() {
        return this.user;
    }

    public Ref getRef() {
        return this.ref;
    }

    public RevId getRevision() {
        return new RevId(ObjectId.toString(this.ref.getObjectId()));
    }

    public String getRefName() {
        return RefNames.refsEdit(this.user.getAccountId(), this.change.getId(), this.basePatchSet.getId());
    }

    public RevCommit getEditCommit() {
        return this.editCommit;
    }

    public PatchSet getBasePatchSet() {
        return this.basePatchSet;
    }
}

