/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.git;

import com.google.gerrit.common.data.GroupReference;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.server.git.TabFile;
import com.google.gerrit.server.git.ValidationError;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupList
extends TabFile {
    private static final Logger log = LoggerFactory.getLogger(GroupList.class);
    public static final String FILE_NAME = "groups";
    private final Map<AccountGroup.UUID, GroupReference> byUUID;

    private GroupList(Map<AccountGroup.UUID, GroupReference> byUUID) {
        this.byUUID = byUUID;
    }

    public static GroupList parse(Project.NameKey project, String text, ValidationError.Sink errors) throws IOException {
        List<TabFile.Row> rows = GroupList.parse(text, FILE_NAME, TRIM, TRIM, errors);
        HashMap<AccountGroup.UUID, GroupReference> groupsByUUID = new HashMap<AccountGroup.UUID, GroupReference>(rows.size());
        for (TabFile.Row row : rows) {
            if (row.left == null) {
                log.warn("null field in group list for {}:\n{}", (Object)project, (Object)text);
                continue;
            }
            AccountGroup.UUID uuid = new AccountGroup.UUID(row.left);
            String name = row.right;
            GroupReference ref = new GroupReference(uuid, name);
            groupsByUUID.put(uuid, ref);
        }
        return new GroupList(groupsByUUID);
    }

    public GroupReference byUUID(AccountGroup.UUID uuid) {
        return this.byUUID.get(uuid);
    }

    public GroupReference resolve(GroupReference group) {
        if (group != null) {
            if (group.getUUID() == null || group.getUUID().get() == null) {
                return group;
            }
            GroupReference ref = this.byUUID.get(group.getUUID());
            if (ref != null) {
                return ref;
            }
            this.byUUID.put(group.getUUID(), group);
        }
        return group;
    }

    public Collection<GroupReference> references() {
        return this.byUUID.values();
    }

    public Set<AccountGroup.UUID> uuids() {
        return this.byUUID.keySet();
    }

    public void put(AccountGroup.UUID uuid, GroupReference reference) {
        if (uuid == null || uuid.get() == null) {
            return;
        }
        this.byUUID.put(uuid, reference);
    }

    public String asText() {
        if (this.byUUID.isEmpty()) {
            return null;
        }
        ArrayList<TabFile.Row> rows = new ArrayList<TabFile.Row>(this.byUUID.size());
        for (GroupReference g : GroupList.sort(this.byUUID.values())) {
            if (g.getUUID() == null || g.getName() == null) continue;
            rows.add(new TabFile.Row(g.getUUID().get(), g.getName()));
        }
        return GroupList.asText("UUID", "Group Name", rows);
    }

    public void retainUUIDs(Collection<AccountGroup.UUID> toBeRetained) {
        this.byUUID.keySet().retainAll(toBeRetained);
    }
}

