/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.group;

import com.google.common.collect.ImmutableList;
import com.google.gerrit.audit.AuditService;
import com.google.gerrit.common.data.GroupDescription;
import com.google.gerrit.extensions.restapi.AuthException;
import com.google.gerrit.extensions.restapi.MethodNotAllowedException;
import com.google.gerrit.extensions.restapi.Response;
import com.google.gerrit.extensions.restapi.RestModifyView;
import com.google.gerrit.extensions.restapi.UnprocessableEntityException;
import com.google.gerrit.reviewdb.client.Account;
import com.google.gerrit.reviewdb.client.AccountGroup;
import com.google.gerrit.reviewdb.client.AccountGroupById;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.CurrentUser;
import com.google.gerrit.server.account.GroupControl;
import com.google.gerrit.server.account.GroupIncludeCache;
import com.google.gerrit.server.group.AddIncludedGroups;
import com.google.gerrit.server.group.GroupResource;
import com.google.gerrit.server.group.GroupsCollection;
import com.google.gerrit.server.group.IncludedGroupResource;
import com.google.gwtorm.server.OrmException;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class DeleteIncludedGroups
implements RestModifyView<GroupResource, AddIncludedGroups.Input> {
    private final GroupsCollection groupsCollection;
    private final GroupIncludeCache groupIncludeCache;
    private final Provider<ReviewDb> db;
    private final Provider<CurrentUser> self;
    private final AuditService auditService;

    @Inject
    DeleteIncludedGroups(GroupsCollection groupsCollection, GroupIncludeCache groupIncludeCache, Provider<ReviewDb> db, Provider<CurrentUser> self, AuditService auditService) {
        this.groupsCollection = groupsCollection;
        this.groupIncludeCache = groupIncludeCache;
        this.db = db;
        this.self = self;
        this.auditService = auditService;
    }

    public Response<?> apply(GroupResource resource, AddIncludedGroups.Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException {
        AccountGroup internalGroup = resource.toAccountGroup();
        if (internalGroup == null) {
            throw new MethodNotAllowedException();
        }
        input = AddIncludedGroups.Input.init(input);
        GroupControl control = resource.getControl();
        Map<AccountGroup.UUID, AccountGroupById> includedGroups = this.getIncludedGroups(internalGroup.getId());
        ArrayList<AccountGroupById> toRemove = new ArrayList<AccountGroupById>();
        for (String includedGroup : input.groups) {
            GroupDescription.Basic d = this.groupsCollection.parse(includedGroup);
            if (!control.canRemoveGroup()) {
                throw new AuthException(String.format("Cannot delete group: %s", d.getName()));
            }
            AccountGroupById g = includedGroups.remove(d.getGroupUUID());
            if (g == null) continue;
            toRemove.add(g);
        }
        if (!toRemove.isEmpty()) {
            this.writeAudits(toRemove);
            this.db.get().accountGroupById().delete(toRemove);
            for (AccountGroupById g : toRemove) {
                this.groupIncludeCache.evictParentGroupsOf(g.getIncludeUUID());
            }
            this.groupIncludeCache.evictSubgroupsOf(internalGroup.getGroupUUID());
        }
        return Response.none();
    }

    private Map<AccountGroup.UUID, AccountGroupById> getIncludedGroups(AccountGroup.Id groupId) throws OrmException {
        HashMap<AccountGroup.UUID, AccountGroupById> groups = new HashMap<AccountGroup.UUID, AccountGroupById>();
        for (AccountGroupById g : this.db.get().accountGroupById().byGroup(groupId)) {
            groups.put(g.getIncludeUUID(), g);
        }
        return groups;
    }

    private void writeAudits(List<AccountGroupById> toRemoved) {
        Account.Id me = this.self.get().getAccountId();
        this.auditService.dispatchDeleteGroupsFromGroup(me, toRemoved);
    }

    @Singleton
    static class DeleteIncludedGroup
    implements RestModifyView<IncludedGroupResource, Input> {
        private final Provider<DeleteIncludedGroups> delete;

        @Inject
        DeleteIncludedGroup(Provider<DeleteIncludedGroups> delete) {
            this.delete = delete;
        }

        public Response<?> apply(IncludedGroupResource resource, Input input) throws AuthException, MethodNotAllowedException, UnprocessableEntityException, OrmException {
            AddIncludedGroups.Input in = new AddIncludedGroups.Input();
            in.groups = ImmutableList.of(resource.getMember().get());
            return this.delete.get().apply(resource, in);
        }

        static class Input {
            Input() {
            }
        }
    }
}

