/*
 * Decompiled with CFR 0.152.
 */
package com.google.gerrit.server.index.change;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.gerrit.reviewdb.client.Change;
import com.google.gerrit.reviewdb.client.Project;
import com.google.gerrit.reviewdb.server.ReviewDb;
import com.google.gerrit.server.git.GitRepositoryManager;
import com.google.gerrit.server.git.MultiProgressMonitor;
import com.google.gerrit.server.git.QueueProvider;
import com.google.gerrit.server.index.IndexExecutor;
import com.google.gerrit.server.index.SiteIndexer;
import com.google.gerrit.server.index.change.ChangeIndex;
import com.google.gerrit.server.index.change.ChangeIndexer;
import com.google.gerrit.server.notedb.ChangeNotes;
import com.google.gerrit.server.project.ProjectCache;
import com.google.gerrit.server.query.change.ChangeData;
import com.google.gwtorm.server.SchemaFactory;
import com.google.inject.Inject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.TextProgressMonitor;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevObject;
import org.eclipse.jgit.revwalk.RevWalk;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AllChangesIndexer
extends SiteIndexer<Change.Id, ChangeData, ChangeIndex> {
    private static final Logger log = LoggerFactory.getLogger(AllChangesIndexer.class);
    private final SchemaFactory<ReviewDb> schemaFactory;
    private final ChangeData.Factory changeDataFactory;
    private final GitRepositoryManager repoManager;
    private final ListeningExecutorService executor;
    private final ChangeIndexer.Factory indexerFactory;
    private final ChangeNotes.Factory notesFactory;
    private final ProjectCache projectCache;

    @Inject
    AllChangesIndexer(SchemaFactory<ReviewDb> schemaFactory, ChangeData.Factory changeDataFactory, GitRepositoryManager repoManager, @IndexExecutor(value=QueueProvider.QueueType.BATCH) ListeningExecutorService executor, ChangeIndexer.Factory indexerFactory, ChangeNotes.Factory notesFactory, ProjectCache projectCache) {
        this.schemaFactory = schemaFactory;
        this.changeDataFactory = changeDataFactory;
        this.repoManager = repoManager;
        this.executor = executor;
        this.indexerFactory = indexerFactory;
        this.notesFactory = notesFactory;
        this.projectCache = projectCache;
    }

    @Override
    public SiteIndexer.Result indexAll(ChangeIndex index) {
        TextProgressMonitor pm = new TextProgressMonitor();
        pm.beginTask("Collecting projects", 0);
        TreeSet<ProjectHolder> projects = new TreeSet<ProjectHolder>();
        int changeCount = 0;
        Stopwatch sw = Stopwatch.createStarted();
        int projectsFailed = 0;
        for (Project.NameKey name : this.projectCache.all()) {
            block9: {
                try (Repository repo = this.repoManager.openRepository(name);){
                    int size = ChangeNotes.Factory.scan(repo).size();
                    changeCount += size;
                    projects.add(new ProjectHolder(name, size));
                }
                catch (IOException e) {
                    log.error("Error collecting project {}", (Object)name, (Object)e);
                    if (++projectsFailed <= projects.size() / 2) break block9;
                    log.error("Over 50% of the projects could not be collected: aborted");
                    return new SiteIndexer.Result(sw, false, 0, 0);
                }
            }
            pm.update(1);
        }
        pm.endTask();
        this.setTotalWork(changeCount);
        return this.indexAll(index, projects);
    }

    public SiteIndexer.Result indexAll(ChangeIndex index, Iterable<ProjectHolder> projects) {
        Stopwatch sw = Stopwatch.createStarted();
        MultiProgressMonitor mpm = new MultiProgressMonitor(this.progressOut, "Reindexing changes");
        MultiProgressMonitor.Task projTask = mpm.beginSubTask("projects", projects instanceof Collection ? ((Collection)projects).size() : 0);
        MultiProgressMonitor.Task doneTask = mpm.beginSubTask(null, this.totalWork >= 0 ? this.totalWork : 0);
        MultiProgressMonitor.Task failedTask = mpm.beginSubTask("failed", 0);
        ArrayList<Future> futures = new ArrayList<Future>();
        AtomicBoolean ok = new AtomicBoolean(true);
        for (ProjectHolder project : projects) {
            Future future = this.executor.submit(this.reindexProject(this.indexerFactory.create(this.executor, index), project.name, doneTask, failedTask, this.verboseWriter));
            this.addErrorListener((ListenableFuture<?>)future, "project " + project.name, projTask, ok);
            futures.add(future);
        }
        try {
            mpm.waitFor(Futures.transform(Futures.successfulAsList(futures), x -> {
                mpm.end();
                return null;
            }, MoreExecutors.directExecutor()));
        }
        catch (ExecutionException e) {
            log.error("Error in batch indexer", e);
            ok.set(false);
        }
        int nFailed = failedTask.getCount();
        int nDone = doneTask.getCount();
        int nTotal = nFailed + nDone;
        double pctFailed = (double)nFailed / (double)nTotal * 100.0;
        if (pctFailed > 10.0) {
            log.error("Failed {}/{} changes ({}%); not marking new index as ready", nFailed, nTotal, Math.round(pctFailed));
            ok.set(false);
        }
        return new SiteIndexer.Result(sw, ok.get(), nDone, nFailed);
    }

    public Callable<Void> reindexProject(final ChangeIndexer indexer, final Project.NameKey project, final MultiProgressMonitor.Task done, final MultiProgressMonitor.Task failed, final PrintWriter verboseWriter) {
        return new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Multimap byId = MultimapBuilder.hashKeys().arrayListValues().build();
                try (Repository repo = AllChangesIndexer.this.repoManager.openRepository(project);
                     ReviewDb db = (ReviewDb)AllChangesIndexer.this.schemaFactory.open();){
                    Map<String, Ref> refs = repo.getRefDatabase().getRefs("");
                    for (ChangeNotes cn : AllChangesIndexer.this.notesFactory.scan(repo, db, project)) {
                        Ref r = refs.get(cn.getChange().currentPatchSetId().toRefName());
                        if (r == null) continue;
                        byId.put(r.getObjectId(), AllChangesIndexer.this.changeDataFactory.create(db, cn));
                    }
                    new ProjectIndexer(indexer, (ListMultimap)byId, repo, done, failed, verboseWriter).call();
                }
                catch (RepositoryNotFoundException rnfe) {
                    log.error(rnfe.getMessage());
                }
                return null;
            }

            public String toString() {
                return "Index all changes of project " + project.get();
            }
        };
    }

    private static class ProjectIndexer
    implements Callable<Void> {
        private final ChangeIndexer indexer;
        private final ListMultimap<ObjectId, ChangeData> byId;
        private final ProgressMonitor done;
        private final ProgressMonitor failed;
        private final PrintWriter verboseWriter;
        private final Repository repo;

        private ProjectIndexer(ChangeIndexer indexer, ListMultimap<ObjectId, ChangeData> changesByCommitId, Repository repo, ProgressMonitor done, ProgressMonitor failed, PrintWriter verboseWriter) {
            this.indexer = indexer;
            this.byId = changesByCommitId;
            this.repo = repo;
            this.done = done;
            this.failed = failed;
            this.verboseWriter = verboseWriter;
        }

        @Override
        public Void call() throws Exception {
            try (RevWalk walk = new RevWalk(this.repo);){
                RevCommit bCommit;
                for (Ref ref : this.repo.getRefDatabase().getRefs("refs/heads/").values()) {
                    RevObject o = walk.parseAny(ref.getObjectId());
                    if (!(o instanceof RevCommit)) continue;
                    walk.markStart((RevCommit)o);
                }
                while ((bCommit = walk.next()) != null && !this.byId.isEmpty()) {
                    if (!this.byId.containsKey(bCommit)) continue;
                    this.index(bCommit);
                    this.byId.removeAll(bCommit);
                }
                for (ObjectId id : this.byId.keySet()) {
                    this.index(id);
                }
            }
            return null;
        }

        private void index(ObjectId b) throws Exception {
            block6: {
                ArrayList<ChangeData> cds = Lists.newArrayList(this.byId.get((Object)b));
                try {
                    if (cds.isEmpty()) break block6;
                    Iterator cdit = cds.iterator();
                    while (cdit.hasNext()) {
                        ChangeData cd = (ChangeData)cdit.next();
                        try {
                            this.indexer.index(cd);
                            this.done.update(1);
                            this.verboseWriter.println("Reindexed change " + cd.getId());
                        }
                        catch (Exception e) {
                            this.fail("Failed to index change " + cd.getId(), true, e);
                        }
                        cdit.remove();
                    }
                }
                catch (Exception e) {
                    this.fail("Failed to index commit " + b.name(), false, e);
                    for (ChangeData cd : cds) {
                        this.fail("Failed to index change " + cd.getId(), true, null);
                    }
                }
            }
        }

        private void fail(String error, boolean failed, Exception e) {
            if (failed) {
                this.failed.update(1);
            }
            if (e != null) {
                log.warn(error, e);
            } else {
                log.warn(error);
            }
            this.verboseWriter.println(error);
        }
    }

    private static class ProjectHolder
    implements Comparable<ProjectHolder> {
        private Project.NameKey name;
        private int size;

        ProjectHolder(Project.NameKey name, int size) {
            this.name = name;
            this.size = size;
        }

        @Override
        public int compareTo(ProjectHolder other) {
            return ComparisonChain.start().compare(other.size, this.size).compare((Comparable<?>)((Object)other.name.get()), (Comparable<?>)((Object)this.name.get())).result();
        }
    }
}

